/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.documentation.generator;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.graylog2.shared.ServerVersion;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator {
    private static final Logger LOG = LoggerFactory.getLogger(Generator.class);
    public static final String EMULATED_SWAGGER_VERSION = "1.2";
    private static Map<String, Object> overviewResult = Maps.newHashMap();
    private static Reflections reflections;
    private final Map<Class<?>, String> pluginMapping;
    private final String pluginPathPrefix;
    private final ObjectMapper mapper;

    public Generator(Set<String> packageNames, Map<Class<?>, String> pluginMapping, String pluginPathPrefix, ObjectMapper mapper) {
        this.pluginMapping = pluginMapping;
        this.pluginPathPrefix = pluginPathPrefix;
        this.mapper = mapper;
        if (reflections == null) {
            reflections = new Reflections(new Object[]{packageNames.toArray(), pluginMapping.keySet().stream().map(Class::getClassLoader).collect(Collectors.toSet())});
        }
    }

    public Generator(String packageName, ObjectMapper mapper) {
        this((Set<String>)ImmutableSet.of((Object)packageName), (Map<Class<?>, String>)ImmutableMap.of(), "", mapper);
    }

    private String prefixedPath(Class<?> resourceClass, @Nullable String resourceAnnotationPath) {
        String resourcePath = Strings.nullToEmpty((String)resourceAnnotationPath);
        StringBuilder prefixedPath = new StringBuilder();
        if (this.pluginMapping.containsKey(resourceClass)) {
            prefixedPath.append(this.pluginPathPrefix);
            prefixedPath.append("/");
            prefixedPath.append(this.pluginMapping.get(resourceClass));
        }
        if (!resourcePath.startsWith("/")) {
            prefixedPath.append("/");
        }
        return prefixedPath.append(resourcePath).toString();
    }

    public synchronized Map<String, Object> generateOverview() {
        if (!overviewResult.isEmpty()) {
            return overviewResult;
        }
        ArrayList apis = Lists.newArrayList();
        for (Class<?> clazz : this.getAnnotatedClasses()) {
            Api info = clazz.getAnnotation(Api.class);
            Path path = clazz.getAnnotation(Path.class);
            if (info == null || path == null) {
                LOG.debug("Skipping REST resource with no Api or Path annotation: <{}>", (Object)clazz.getCanonicalName());
                continue;
            }
            String prefixedPath = this.prefixedPath(clazz, path.value());
            HashMap apiDescription = Maps.newHashMap();
            apiDescription.put("name", prefixedPath.startsWith(this.pluginPathPrefix) ? "Plugins/" + info.value() : info.value());
            apiDescription.put("path", prefixedPath);
            apiDescription.put("description", info.description());
            apis.add(apiDescription);
        }
        Collections.sort(apis, (o1, o2) -> ComparisonChain.start().compare((Comparable)((Object)o1.get("name").toString()), (Comparable)((Object)o2.get("name").toString())).result());
        HashMap info = Maps.newHashMap();
        info.put("title", "Graylog REST API");
        overviewResult.put("apiVersion", ServerVersion.VERSION.toString());
        overviewResult.put("swaggerVersion", EMULATED_SWAGGER_VERSION);
        overviewResult.put("apis", apis);
        return overviewResult;
    }

    public Set<Class<?>> getAnnotatedClasses() {
        return reflections.getTypesAnnotatedWith(Api.class);
    }

    public Map<String, Object> generateForRoute(String route, String basePath) {
        HashMap result = Maps.newHashMap();
        HashSet modelTypes = Sets.newHashSet();
        ArrayList apis = Lists.newArrayList();
        for (Class<?> clazz : this.getAnnotatedClasses()) {
            Path path = clazz.getAnnotation(Path.class);
            if (path == null) {
                LOG.debug("Skipping REST resource with no Api or Path annotation: <{}>", (Object)clazz.getCanonicalName());
                continue;
            }
            String prefixedPath = this.prefixedPath(clazz, path.value());
            if (!this.cleanRoute(route).equals(this.cleanRoute(prefixedPath))) continue;
            LOG.debug("Found corresponding REST resource class: <{}>", (Object)clazz.getCanonicalName());
            Method[] methods = clazz.getDeclaredMethods();
            if (methods == null || methods.length == 0) {
                LOG.debug("REST resource <{}> has no methods. Skipping.", (Object)clazz.getCanonicalName());
                break;
            }
            for (Method method : methods) {
                List<Parameter> parameters;
                String methodPath;
                if (!method.isAnnotationPresent(ApiOperation.class)) {
                    LOG.debug("Method <{}> has no ApiOperation annotation. Skipping.", (Object)method.toGenericString());
                    continue;
                }
                ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
                HashMap api = Maps.newHashMap();
                ArrayList operations = Lists.newArrayList();
                if (method.isAnnotationPresent(Path.class)) {
                    methodPath = this.cleanRoute(method.getAnnotation(Path.class).value());
                    if (clazz.isAnnotationPresent(Path.class)) {
                        String classPath = this.cleanRoute(this.prefixedPath(clazz, clazz.getAnnotation(Path.class).value()));
                        methodPath = classPath + methodPath;
                    }
                } else if (clazz.isAnnotationPresent(Path.class)) {
                    methodPath = this.cleanRoute(this.prefixedPath(clazz, clazz.getAnnotation(Path.class).value()));
                } else {
                    LOG.debug("Method <{}> has no Path annotation. Skipping.", (Object)method.toGenericString());
                    continue;
                }
                Produces produces = null;
                if (clazz.isAnnotationPresent(Produces.class) || method.isAnnotationPresent(Produces.class)) {
                    produces = clazz.getAnnotation(Produces.class);
                    if (method.isAnnotationPresent(Produces.class)) {
                        produces = method.getAnnotation(Produces.class);
                    }
                }
                api.put("path", methodPath);
                HashMap operation = Maps.newHashMap();
                operation.put("method", this.determineHttpMethod(method));
                operation.put("summary", apiOperation.value());
                operation.put("notes", apiOperation.notes());
                operation.put("nickname", method.getName());
                if (produces != null) {
                    operation.put("produces", produces.value());
                }
                if (!method.getReturnType().isAssignableFrom(Response.class)) {
                    operation.put("type", method.getReturnType().getSimpleName());
                    modelTypes.add(method.getReturnType());
                }
                if ((parameters = this.determineParameters(method)) != null && !parameters.isEmpty()) {
                    operation.put("parameters", parameters);
                }
                for (Parameter parameter : parameters) {
                    Class type = parameter.getType();
                    if (Primitives.unwrap((Class)type).isPrimitive() || type.equals(String.class)) continue;
                    modelTypes.add(type);
                }
                operation.put("responseMessages", this.determineResponses(method));
                operations.add(operation);
                api.put("operations", operations);
                apis.add(api);
            }
        }
        if (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        Collections.sort(apis, (o1, o2) -> ComparisonChain.start().compare((Comparable)((Object)o1.get("path").toString()), (Comparable)((Object)o2.get("path").toString())).result());
        HashMap models = Maps.newHashMap();
        for (Class type : modelTypes) {
            if (!type.isAnnotationPresent(JsonAutoDetect.class)) continue;
            try {
                SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
                this.mapper.acceptJsonFormatVisitor(this.mapper.constructType((Type)type), (JsonFormatVisitorWrapper)visitor);
                JsonSchema schema = visitor.finalSchema();
                models.put(type.getSimpleName(), schema);
            }
            catch (JsonMappingException e) {
                LOG.error("Error generating model schema. Ignoring this model, this will likely break the API browser.", (Throwable)e);
            }
        }
        result.put("apis", apis);
        result.put("basePath", basePath);
        result.put("models", models);
        result.put("resourcePath", this.cleanRoute(route));
        result.put("apiVersion", ServerVersion.VERSION.toString());
        result.put("swaggerVersion", EMULATED_SWAGGER_VERSION);
        return result;
    }

    private List<Parameter> determineParameters(Method method) {
        ArrayList params = Lists.newArrayList();
        int i = 0;
        for (Annotation[] annotations : method.getParameterAnnotations()) {
            Parameter param = new Parameter();
            Parameter.Kind paramKind = Parameter.Kind.BODY;
            for (Annotation annotation : annotations) {
                if (annotation instanceof ApiParam) {
                    ApiParam apiParam = (ApiParam)annotation;
                    param.setName(apiParam.name());
                    param.setDescription(apiParam.value());
                    param.setIsRequired(apiParam.required());
                    param.setType(method.getGenericParameterTypes()[i]);
                }
                if (annotation instanceof QueryParam) {
                    paramKind = Parameter.Kind.QUERY;
                    continue;
                }
                if (annotation instanceof PathParam) {
                    paramKind = Parameter.Kind.PATH;
                    continue;
                }
                if (annotation instanceof HeaderParam) {
                    paramKind = Parameter.Kind.HEADER;
                    continue;
                }
                if (!(annotation instanceof FormParam)) continue;
                paramKind = Parameter.Kind.FORM;
            }
            param.setKind(paramKind);
            if (param.getType() != null) {
                params.add(param);
            }
            ++i;
        }
        return params;
    }

    private List<Map<String, Object>> determineResponses(Method method) {
        ArrayList result = Lists.newArrayList();
        ApiResponses annotation = method.getAnnotation(ApiResponses.class);
        if (null != annotation) {
            for (ApiResponse response : annotation.value()) {
                ImmutableMap responseDescription = ImmutableMap.of((Object)"code", (Object)response.code(), (Object)"message", (Object)response.message());
                result.add(responseDescription);
            }
        }
        return result;
    }

    private String cleanRoute(String route) {
        if (!route.startsWith("/")) {
            route = "/" + route;
        }
        if (route.endsWith("/")) {
            route = route.substring(0, route.length() - 1);
        }
        return route;
    }

    @Nullable
    private String determineHttpMethod(Method m) {
        if (m.isAnnotationPresent(GET.class)) {
            return "GET";
        }
        if (m.isAnnotationPresent(POST.class)) {
            return "POST";
        }
        if (m.isAnnotationPresent(PUT.class)) {
            return "PUT";
        }
        if (m.isAnnotationPresent(DELETE.class)) {
            return "DELETE";
        }
        if (m.isAnnotationPresent(HEAD.class)) {
            return "HEAD";
        }
        if (m.isAnnotationPresent(OPTIONS.class)) {
            return "OPTIONS";
        }
        return null;
    }

    public static class Parameter {
        private String name;
        private String description;
        private boolean isRequired;
        private Class type;
        private Kind kind;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public void setIsRequired(boolean required) {
            this.isRequired = required;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public void setRequired(boolean required) {
            this.isRequired = required;
        }

        public void setType(Type type) {
            Class klass = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : (Class)type;
            this.type = klass.isPrimitive() ? Primitives.wrap((Class)klass) : klass;
        }

        @JsonIgnore
        public Class getType() {
            return this.type;
        }

        @JsonProperty(value="type")
        public String getTypeName() {
            return this.type.getSimpleName();
        }

        public void setKind(Kind kind) {
            this.kind = kind;
        }

        @JsonProperty(value="paramType")
        public String getKind() {
            return this.kind.toString().toLowerCase(Locale.ENGLISH);
        }

        public static enum Kind {
            BODY,
            HEADER,
            PATH,
            QUERY,
            FORM;

        }
    }
}

