/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.users;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DuplicateKeyException;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.shared.security.Permissions;
import org.graylog2.shared.users.Role;
import org.graylog2.shared.users.Roles;
import org.graylog2.users.RoleImpl;
import org.graylog2.users.RoleService;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleServiceImpl
implements RoleService {
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);
    private static final String ROLES = "roles";
    private static final String NAME_LOWER = "name_lower";
    private static final String READ_ONLY = "read_only";
    private static final String ADMIN_ROLENAME = "Admin";
    private static final String READER_ROLENAME = "Reader";
    private final JacksonDBCollection<RoleImpl, ObjectId> dbCollection;
    private final Validator validator;
    private final String adminRoleObjectId;
    private final String readerRoleObjectId;

    @Inject
    protected RoleServiceImpl(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, Permissions permissions, Validator validator) {
        this.validator = validator;
        this.dbCollection = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(ROLES), RoleImpl.class, ObjectId.class, (ObjectMapper)mapper.get());
        this.dbCollection.createIndex((DBObject)new BasicDBObject(NAME_LOWER, (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        this.adminRoleObjectId = (String)Preconditions.checkNotNull((Object)this.ensureBuiltinRole(ADMIN_ROLENAME, Sets.newHashSet((Object[])new String[]{"*"}), ADMIN_ROLENAME, "Grants all permissions for Graylog administrators (built-in)"));
        this.readerRoleObjectId = (String)Preconditions.checkNotNull((Object)this.ensureBuiltinRole(READER_ROLENAME, permissions.readerBasePermissions(), READER_ROLENAME, "Grants basic permissions for every Graylog user (built-in)"));
    }

    @Nullable
    private String ensureBuiltinRole(String roleName, Set<String> expectedPermissions, String name, String description) {
        RoleImpl previousRole = null;
        try {
            previousRole = this.load(roleName);
            if (!previousRole.isReadOnly() || !expectedPermissions.equals(previousRole.getPermissions())) {
                log.error("Invalid role '{}', fixing it.", (Object)roleName);
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalArgumentException | NoSuchElementException | NotFoundException ignored) {
            log.info("{} role is missing or invalid, re-adding it as a built-in role.", (Object)roleName);
            RoleImpl fixedAdmin = new RoleImpl();
            if (previousRole != null) {
                fixedAdmin._id = previousRole._id;
            }
            fixedAdmin.setReadOnly(true);
            fixedAdmin.setName(name);
            fixedAdmin.setDescription(description);
            fixedAdmin.setPermissions(expectedPermissions);
            try {
                RoleImpl savedRole = this.save(fixedAdmin);
                return savedRole.getId();
            }
            catch (DuplicateKeyException | ValidationException e) {
                log.error("Unable to save fixed " + roleName + " role, please restart Graylog to fix this.", e);
            }
        }
        if (previousRole == null) {
            log.error("Unable to access fixed " + roleName + " role, please restart Graylog to fix this.");
            return null;
        }
        return previousRole.getId();
    }

    @Override
    public Role loadById(String roleId) throws NotFoundException {
        Role role = (Role)this.dbCollection.findOneById((Object)new ObjectId(roleId));
        if (role == null) {
            throw new NotFoundException("No role found with id " + roleId);
        }
        return role;
    }

    @Override
    public RoleImpl load(String roleName) throws NotFoundException {
        RoleImpl role = (RoleImpl)this.dbCollection.findOne(DBQuery.is((String)NAME_LOWER, (Object)roleName.toLowerCase(Locale.ENGLISH)));
        if (role == null) {
            throw new NotFoundException("No role found with name " + roleName);
        }
        return role;
    }

    @Override
    public boolean exists(String roleName) {
        return this.dbCollection.getCount(DBQuery.is((String)NAME_LOWER, (Object)roleName.toLowerCase(Locale.ENGLISH))) == 1L;
    }

    @Override
    public Set<Role> loadAll() throws NotFoundException {
        DBCursor rolesCursor = this.dbCollection.find();
        return Sets.newHashSet((Iterable)rolesCursor);
    }

    @Override
    public Map<String, Role> loadAllIdMap() throws NotFoundException {
        Set<Role> roles = this.loadAll();
        return Maps.uniqueIndex(roles, (Function)new Function<Role, String>(){

            @Nullable
            public String apply(Role input) {
                return input.getId();
            }
        });
    }

    @Override
    public Map<String, Role> loadAllLowercaseNameMap() throws NotFoundException {
        Set<Role> roles = this.loadAll();
        return Maps.uniqueIndex(roles, (Function)Roles.roleToNameFunction(true));
    }

    @Override
    public RoleImpl save(Role role1) throws ValidationException {
        if (!(role1 instanceof RoleImpl)) {
            throw new IllegalArgumentException("invalid Role implementation class");
        }
        RoleImpl role = (RoleImpl)role1;
        Set<ConstraintViolation<Role>> violations = this.validate(role);
        if (!violations.isEmpty()) {
            throw new ValidationException("Validation failed.", violations.toString());
        }
        WriteResult writeResult = this.dbCollection.save((Object)role);
        return (RoleImpl)writeResult.getSavedObject();
    }

    @Override
    public Set<ConstraintViolation<Role>> validate(Role role) {
        return this.validator.validate((Object)role, new Class[0]);
    }

    @Override
    public int delete(String roleName) {
        DBQuery.Query nameMatchesAndNotReadonly = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)READ_ONLY, (Object)false), DBQuery.is((String)NAME_LOWER, (Object)roleName.toLowerCase(Locale.ENGLISH))});
        return this.dbCollection.remove(nameMatchesAndNotReadonly).getN();
    }

    @Override
    public String getAdminRoleObjectId() {
        return this.adminRoleObjectId;
    }

    @Override
    public String getReaderRoleObjectId() {
        return this.readerRoleObjectId;
    }
}

