webpackJsonp([20],{95:function(module,exports,__webpack_require__){eval('var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*\nstring.js - Copyright (C) 2012-2014, JP Richardson <jprichardson@gmail.com>\n*/\n\n!(function() {\n  "use strict";\n\n  var VERSION = \'3.3.1\';\n\n  var ENTITIES = {};\n\n  // from http://semplicewebsites.com/removing-accents-javascript\n  var latin_map={"Á":"A","Ă":"A","Ắ":"A","Ặ":"A","Ằ":"A","Ẳ":"A","Ẵ":"A","Ǎ":"A","Â":"A","Ấ":"A","Ậ":"A","Ầ":"A","Ẩ":"A","Ẫ":"A","Ä":"A","Ǟ":"A","Ȧ":"A","Ǡ":"A","Ạ":"A","Ȁ":"A","À":"A","Ả":"A","Ȃ":"A","Ā":"A","Ą":"A","Å":"A","Ǻ":"A","Ḁ":"A","Ⱥ":"A","Ã":"A","Ꜳ":"AA","Æ":"AE","Ǽ":"AE","Ǣ":"AE","Ꜵ":"AO","Ꜷ":"AU","Ꜹ":"AV","Ꜻ":"AV","Ꜽ":"AY","Ḃ":"B","Ḅ":"B","Ɓ":"B","Ḇ":"B","Ƀ":"B","Ƃ":"B","Ć":"C","Č":"C","Ç":"C","Ḉ":"C","Ĉ":"C","Ċ":"C","Ƈ":"C","Ȼ":"C","Ď":"D","Ḑ":"D","Ḓ":"D","Ḋ":"D","Ḍ":"D","Ɗ":"D","Ḏ":"D","ǲ":"D","ǅ":"D","Đ":"D","Ƌ":"D","Ǳ":"DZ","Ǆ":"DZ","É":"E","Ĕ":"E","Ě":"E","Ȩ":"E","Ḝ":"E","Ê":"E","Ế":"E","Ệ":"E","Ề":"E","Ể":"E","Ễ":"E","Ḙ":"E","Ë":"E","Ė":"E","Ẹ":"E","Ȅ":"E","È":"E","Ẻ":"E","Ȇ":"E","Ē":"E","Ḗ":"E","Ḕ":"E","Ę":"E","Ɇ":"E","Ẽ":"E","Ḛ":"E","Ꝫ":"ET","Ḟ":"F","Ƒ":"F","Ǵ":"G","Ğ":"G","Ǧ":"G","Ģ":"G","Ĝ":"G","Ġ":"G","Ɠ":"G","Ḡ":"G","Ǥ":"G","Ḫ":"H","Ȟ":"H","Ḩ":"H","Ĥ":"H","Ⱨ":"H","Ḧ":"H","Ḣ":"H","Ḥ":"H","Ħ":"H","Í":"I","Ĭ":"I","Ǐ":"I","Î":"I","Ï":"I","Ḯ":"I","İ":"I","Ị":"I","Ȉ":"I","Ì":"I","Ỉ":"I","Ȋ":"I","Ī":"I","Į":"I","Ɨ":"I","Ĩ":"I","Ḭ":"I","Ꝺ":"D","Ꝼ":"F","Ᵹ":"G","Ꞃ":"R","Ꞅ":"S","Ꞇ":"T","Ꝭ":"IS","Ĵ":"J","Ɉ":"J","Ḱ":"K","Ǩ":"K","Ķ":"K","Ⱪ":"K","Ꝃ":"K","Ḳ":"K","Ƙ":"K","Ḵ":"K","Ꝁ":"K","Ꝅ":"K","Ĺ":"L","Ƚ":"L","Ľ":"L","Ļ":"L","Ḽ":"L","Ḷ":"L","Ḹ":"L","Ⱡ":"L","Ꝉ":"L","Ḻ":"L","Ŀ":"L","Ɫ":"L","ǈ":"L","Ł":"L","Ǉ":"LJ","Ḿ":"M","Ṁ":"M","Ṃ":"M","Ɱ":"M","Ń":"N","Ň":"N","Ņ":"N","Ṋ":"N","Ṅ":"N","Ṇ":"N","Ǹ":"N","Ɲ":"N","Ṉ":"N","Ƞ":"N","ǋ":"N","Ñ":"N","Ǌ":"NJ","Ó":"O","Ŏ":"O","Ǒ":"O","Ô":"O","Ố":"O","Ộ":"O","Ồ":"O","Ổ":"O","Ỗ":"O","Ö":"O","Ȫ":"O","Ȯ":"O","Ȱ":"O","Ọ":"O","Ő":"O","Ȍ":"O","Ò":"O","Ỏ":"O","Ơ":"O","Ớ":"O","Ợ":"O","Ờ":"O","Ở":"O","Ỡ":"O","Ȏ":"O","Ꝋ":"O","Ꝍ":"O","Ō":"O","Ṓ":"O","Ṑ":"O","Ɵ":"O","Ǫ":"O","Ǭ":"O","Ø":"O","Ǿ":"O","Õ":"O","Ṍ":"O","Ṏ":"O","Ȭ":"O","Ƣ":"OI","Ꝏ":"OO","Ɛ":"E","Ɔ":"O","Ȣ":"OU","Ṕ":"P","Ṗ":"P","Ꝓ":"P","Ƥ":"P","Ꝕ":"P","Ᵽ":"P","Ꝑ":"P","Ꝙ":"Q","Ꝗ":"Q","Ŕ":"R","Ř":"R","Ŗ":"R","Ṙ":"R","Ṛ":"R","Ṝ":"R","Ȑ":"R","Ȓ":"R","Ṟ":"R","Ɍ":"R","Ɽ":"R","Ꜿ":"C","Ǝ":"E","Ś":"S","Ṥ":"S","Š":"S","Ṧ":"S","Ş":"S","Ŝ":"S","Ș":"S","Ṡ":"S","Ṣ":"S","Ṩ":"S","ẞ":"SS","Ť":"T","Ţ":"T","Ṱ":"T","Ț":"T","Ⱦ":"T","Ṫ":"T","Ṭ":"T","Ƭ":"T","Ṯ":"T","Ʈ":"T","Ŧ":"T","Ɐ":"A","Ꞁ":"L","Ɯ":"M","Ʌ":"V","Ꜩ":"TZ","Ú":"U","Ŭ":"U","Ǔ":"U","Û":"U","Ṷ":"U","Ü":"U","Ǘ":"U","Ǚ":"U","Ǜ":"U","Ǖ":"U","Ṳ":"U","Ụ":"U","Ű":"U","Ȕ":"U","Ù":"U","Ủ":"U","Ư":"U","Ứ":"U","Ự":"U","Ừ":"U","Ử":"U","Ữ":"U","Ȗ":"U","Ū":"U","Ṻ":"U","Ų":"U","Ů":"U","Ũ":"U","Ṹ":"U","Ṵ":"U","Ꝟ":"V","Ṿ":"V","Ʋ":"V","Ṽ":"V","Ꝡ":"VY","Ẃ":"W","Ŵ":"W","Ẅ":"W","Ẇ":"W","Ẉ":"W","Ẁ":"W","Ⱳ":"W","Ẍ":"X","Ẋ":"X","Ý":"Y","Ŷ":"Y","Ÿ":"Y","Ẏ":"Y","Ỵ":"Y","Ỳ":"Y","Ƴ":"Y","Ỷ":"Y","Ỿ":"Y","Ȳ":"Y","Ɏ":"Y","Ỹ":"Y","Ź":"Z","Ž":"Z","Ẑ":"Z","Ⱬ":"Z","Ż":"Z","Ẓ":"Z","Ȥ":"Z","Ẕ":"Z","Ƶ":"Z","Ĳ":"IJ","Œ":"OE","ᴀ":"A","ᴁ":"AE","ʙ":"B","ᴃ":"B","ᴄ":"C","ᴅ":"D","ᴇ":"E","ꜰ":"F","ɢ":"G","ʛ":"G","ʜ":"H","ɪ":"I","ʁ":"R","ᴊ":"J","ᴋ":"K","ʟ":"L","ᴌ":"L","ᴍ":"M","ɴ":"N","ᴏ":"O","ɶ":"OE","ᴐ":"O","ᴕ":"OU","ᴘ":"P","ʀ":"R","ᴎ":"N","ᴙ":"R","ꜱ":"S","ᴛ":"T","ⱻ":"E","ᴚ":"R","ᴜ":"U","ᴠ":"V","ᴡ":"W","ʏ":"Y","ᴢ":"Z","á":"a","ă":"a","ắ":"a","ặ":"a","ằ":"a","ẳ":"a","ẵ":"a","ǎ":"a","â":"a","ấ":"a","ậ":"a","ầ":"a","ẩ":"a","ẫ":"a","ä":"a","ǟ":"a","ȧ":"a","ǡ":"a","ạ":"a","ȁ":"a","à":"a","ả":"a","ȃ":"a","ā":"a","ą":"a","ᶏ":"a","ẚ":"a","å":"a","ǻ":"a","ḁ":"a","ⱥ":"a","ã":"a","ꜳ":"aa","æ":"ae","ǽ":"ae","ǣ":"ae","ꜵ":"ao","ꜷ":"au","ꜹ":"av","ꜻ":"av","ꜽ":"ay","ḃ":"b","ḅ":"b","ɓ":"b","ḇ":"b","ᵬ":"b","ᶀ":"b","ƀ":"b","ƃ":"b","ɵ":"o","ć":"c","č":"c","ç":"c","ḉ":"c","ĉ":"c","ɕ":"c","ċ":"c","ƈ":"c","ȼ":"c","ď":"d","ḑ":"d","ḓ":"d","ȡ":"d","ḋ":"d","ḍ":"d","ɗ":"d","ᶑ":"d","ḏ":"d","ᵭ":"d","ᶁ":"d","đ":"d","ɖ":"d","ƌ":"d","ı":"i","ȷ":"j","ɟ":"j","ʄ":"j","ǳ":"dz","ǆ":"dz","é":"e","ĕ":"e","ě":"e","ȩ":"e","ḝ":"e","ê":"e","ế":"e","ệ":"e","ề":"e","ể":"e","ễ":"e","ḙ":"e","ë":"e","ė":"e","ẹ":"e","ȅ":"e","è":"e","ẻ":"e","ȇ":"e","ē":"e","ḗ":"e","ḕ":"e","ⱸ":"e","ę":"e","ᶒ":"e","ɇ":"e","ẽ":"e","ḛ":"e","ꝫ":"et","ḟ":"f","ƒ":"f","ᵮ":"f","ᶂ":"f","ǵ":"g","ğ":"g","ǧ":"g","ģ":"g","ĝ":"g","ġ":"g","ɠ":"g","ḡ":"g","ᶃ":"g","ǥ":"g","ḫ":"h","ȟ":"h","ḩ":"h","ĥ":"h","ⱨ":"h","ḧ":"h","ḣ":"h","ḥ":"h","ɦ":"h","ẖ":"h","ħ":"h","ƕ":"hv","í":"i","ĭ":"i","ǐ":"i","î":"i","ï":"i","ḯ":"i","ị":"i","ȉ":"i","ì":"i","ỉ":"i","ȋ":"i","ī":"i","į":"i","ᶖ":"i","ɨ":"i","ĩ":"i","ḭ":"i","ꝺ":"d","ꝼ":"f","ᵹ":"g","ꞃ":"r","ꞅ":"s","ꞇ":"t","ꝭ":"is","ǰ":"j","ĵ":"j","ʝ":"j","ɉ":"j","ḱ":"k","ǩ":"k","ķ":"k","ⱪ":"k","ꝃ":"k","ḳ":"k","ƙ":"k","ḵ":"k","ᶄ":"k","ꝁ":"k","ꝅ":"k","ĺ":"l","ƚ":"l","ɬ":"l","ľ":"l","ļ":"l","ḽ":"l","ȴ":"l","ḷ":"l","ḹ":"l","ⱡ":"l","ꝉ":"l","ḻ":"l","ŀ":"l","ɫ":"l","ᶅ":"l","ɭ":"l","ł":"l","ǉ":"lj","ſ":"s","ẜ":"s","ẛ":"s","ẝ":"s","ḿ":"m","ṁ":"m","ṃ":"m","ɱ":"m","ᵯ":"m","ᶆ":"m","ń":"n","ň":"n","ņ":"n","ṋ":"n","ȵ":"n","ṅ":"n","ṇ":"n","ǹ":"n","ɲ":"n","ṉ":"n","ƞ":"n","ᵰ":"n","ᶇ":"n","ɳ":"n","ñ":"n","ǌ":"nj","ó":"o","ŏ":"o","ǒ":"o","ô":"o","ố":"o","ộ":"o","ồ":"o","ổ":"o","ỗ":"o","ö":"o","ȫ":"o","ȯ":"o","ȱ":"o","ọ":"o","ő":"o","ȍ":"o","ò":"o","ỏ":"o","ơ":"o","ớ":"o","ợ":"o","ờ":"o","ở":"o","ỡ":"o","ȏ":"o","ꝋ":"o","ꝍ":"o","ⱺ":"o","ō":"o","ṓ":"o","ṑ":"o","ǫ":"o","ǭ":"o","ø":"o","ǿ":"o","õ":"o","ṍ":"o","ṏ":"o","ȭ":"o","ƣ":"oi","ꝏ":"oo","ɛ":"e","ᶓ":"e","ɔ":"o","ᶗ":"o","ȣ":"ou","ṕ":"p","ṗ":"p","ꝓ":"p","ƥ":"p","ᵱ":"p","ᶈ":"p","ꝕ":"p","ᵽ":"p","ꝑ":"p","ꝙ":"q","ʠ":"q","ɋ":"q","ꝗ":"q","ŕ":"r","ř":"r","ŗ":"r","ṙ":"r","ṛ":"r","ṝ":"r","ȑ":"r","ɾ":"r","ᵳ":"r","ȓ":"r","ṟ":"r","ɼ":"r","ᵲ":"r","ᶉ":"r","ɍ":"r","ɽ":"r","ↄ":"c","ꜿ":"c","ɘ":"e","ɿ":"r","ś":"s","ṥ":"s","š":"s","ṧ":"s","ş":"s","ŝ":"s","ș":"s","ṡ":"s","ṣ":"s","ṩ":"s","ʂ":"s","ᵴ":"s","ᶊ":"s","ȿ":"s","ɡ":"g","ß":"ss","ᴑ":"o","ᴓ":"o","ᴝ":"u","ť":"t","ţ":"t","ṱ":"t","ț":"t","ȶ":"t","ẗ":"t","ⱦ":"t","ṫ":"t","ṭ":"t","ƭ":"t","ṯ":"t","ᵵ":"t","ƫ":"t","ʈ":"t","ŧ":"t","ᵺ":"th","ɐ":"a","ᴂ":"ae","ǝ":"e","ᵷ":"g","ɥ":"h","ʮ":"h","ʯ":"h","ᴉ":"i","ʞ":"k","ꞁ":"l","ɯ":"m","ɰ":"m","ᴔ":"oe","ɹ":"r","ɻ":"r","ɺ":"r","ⱹ":"r","ʇ":"t","ʌ":"v","ʍ":"w","ʎ":"y","ꜩ":"tz","ú":"u","ŭ":"u","ǔ":"u","û":"u","ṷ":"u","ü":"u","ǘ":"u","ǚ":"u","ǜ":"u","ǖ":"u","ṳ":"u","ụ":"u","ű":"u","ȕ":"u","ù":"u","ủ":"u","ư":"u","ứ":"u","ự":"u","ừ":"u","ử":"u","ữ":"u","ȗ":"u","ū":"u","ṻ":"u","ų":"u","ᶙ":"u","ů":"u","ũ":"u","ṹ":"u","ṵ":"u","ᵫ":"ue","ꝸ":"um","ⱴ":"v","ꝟ":"v","ṿ":"v","ʋ":"v","ᶌ":"v","ⱱ":"v","ṽ":"v","ꝡ":"vy","ẃ":"w","ŵ":"w","ẅ":"w","ẇ":"w","ẉ":"w","ẁ":"w","ⱳ":"w","ẘ":"w","ẍ":"x","ẋ":"x","ᶍ":"x","ý":"y","ŷ":"y","ÿ":"y","ẏ":"y","ỵ":"y","ỳ":"y","ƴ":"y","ỷ":"y","ỿ":"y","ȳ":"y","ẙ":"y","ɏ":"y","ỹ":"y","ź":"z","ž":"z","ẑ":"z","ʑ":"z","ⱬ":"z","ż":"z","ẓ":"z","ȥ":"z","ẕ":"z","ᵶ":"z","ᶎ":"z","ʐ":"z","ƶ":"z","ɀ":"z","ﬀ":"ff","ﬃ":"ffi","ﬄ":"ffl","ﬁ":"fi","ﬂ":"fl","ĳ":"ij","œ":"oe","ﬆ":"st","ₐ":"a","ₑ":"e","ᵢ":"i","ⱼ":"j","ₒ":"o","ᵣ":"r","ᵤ":"u","ᵥ":"v","ₓ":"x"};\n\n//******************************************************************************\n// Added an initialize function which is essentially the code from the S\n// constructor.  Now, the S constructor calls this and a new method named\n// setValue calls it as well.  The setValue function allows constructors for\n// modules that extend string.js to set the initial value of an object without\n// knowing the internal workings of string.js.\n//\n// Also, all methods which return a new S object now call:\n//\n//      return new this.constructor(s);\n//\n// instead of:\n//\n//      return new S(s);\n//\n// This allows extended objects to keep their proper instanceOf and constructor.\n//******************************************************************************\n\n  function initialize (object, s) {\n    if (s !== null && s !== undefined) {\n      if (typeof s === \'string\')\n        object.s = s;\n      else\n        object.s = s.toString();\n    } else {\n      object.s = s; //null or undefined\n    }\n\n    object.orig = s; //original object, currently only used by toCSV() and toBoolean()\n\n    if (s !== null && s !== undefined) {\n      if (object.__defineGetter__) {\n        object.__defineGetter__(\'length\', function() {\n          return object.s.length;\n        })\n      } else {\n        object.length = s.length;\n      }\n    } else {\n      object.length = -1;\n    }\n  }\n\n  function S(s) {\n  \tinitialize(this, s);\n  }\n\n  var __nsp = String.prototype;\n  var __sp = S.prototype = {\n\n    between: function(left, right) {\n      var s = this.s;\n      var startPos = s.indexOf(left);\n      var endPos = s.indexOf(right, startPos + left.length);\n      if (endPos == -1 && right != null)\n        return new this.constructor(\'\')\n      else if (endPos == -1 && right == null)\n        return new this.constructor(s.substring(startPos + left.length))\n      else\n        return new this.constructor(s.slice(startPos + left.length, endPos));\n    },\n\n    //# modified slightly from https://github.com/epeli/underscore.string\n    camelize: function() {\n      var s = this.trim().s.replace(/(\\-|_|\\s)+(.)?/g, function(mathc, sep, c) {\n        return (c ? c.toUpperCase() : \'\');\n      });\n      return new this.constructor(s);\n    },\n\n    capitalize: function() {\n      return new this.constructor(this.s.substr(0, 1).toUpperCase() + this.s.substring(1).toLowerCase());\n    },\n\n    charAt: function(index) {\n      return this.s.charAt(index);\n    },\n\n    chompLeft: function(prefix) {\n      var s = this.s;\n      if (s.indexOf(prefix) === 0) {\n         s = s.slice(prefix.length);\n         return new this.constructor(s);\n      } else {\n        return this;\n      }\n    },\n\n    chompRight: function(suffix) {\n      if (this.endsWith(suffix)) {\n        var s = this.s;\n        s = s.slice(0, s.length - suffix.length);\n        return new this.constructor(s);\n      } else {\n        return this;\n      }\n    },\n\n    //#thanks Google\n    collapseWhitespace: function() {\n      var s = this.s.replace(/[\\s\\xa0]+/g, \' \').replace(/^\\s+|\\s+$/g, \'\');\n      return new this.constructor(s);\n    },\n\n    contains: function(ss) {\n      return this.s.indexOf(ss) >= 0;\n    },\n\n    count: function(ss) {\n      return __webpack_require__(276)(this.s, ss)\n    },\n\n    //#modified from https://github.com/epeli/underscore.string\n    dasherize: function() {\n      var s = this.trim().s.replace(/[_\\s]+/g, \'-\').replace(/([A-Z])/g, \'-$1\').replace(/-+/g, \'-\').toLowerCase();\n      return new this.constructor(s);\n    },\n\n    latinise: function() {\n      var s = this.replace(/[^A-Za-z0-9\\[\\] ]/g, function(x) { return latin_map[x] || x; });\n      return new this.constructor(s);\n    },\n\n    decodeHtmlEntities: function() { //https://github.com/substack/node-ent/blob/master/index.js\n      var s = this.s;\n      s = s.replace(/&#(\\d+);?/g, function (_, code) {\n        return String.fromCharCode(code);\n      })\n      .replace(/&#[xX]([A-Fa-f0-9]+);?/g, function (_, hex) {\n        return String.fromCharCode(parseInt(hex, 16));\n      })\n      .replace(/&([^;\\W]+;?)/g, function (m, e) {\n        var ee = e.replace(/;$/, \'\');\n        var target = ENTITIES[e] || (e.match(/;$/) && ENTITIES[ee]);\n\n        if (typeof target === \'number\') {\n          return String.fromCharCode(target);\n        }\n        else if (typeof target === \'string\') {\n          return target;\n        }\n        else {\n          return m;\n        }\n      })\n\n      return new this.constructor(s);\n    },\n\n    endsWith: function() {\n      var suffixes = Array.prototype.slice.call(arguments, 0);\n      for (var i = 0; i < suffixes.length; ++i) {\n        var l  = this.s.length - suffixes[i].length;\n        if (l >= 0 && this.s.indexOf(suffixes[i], l) === l) return true;\n      }\n      return false;\n    },\n\n    escapeHTML: function() { //from underscore.string\n      return new this.constructor(this.s.replace(/[&<>"\']/g, function(m){ return \'&\' + reversedEscapeChars[m] + \';\'; }));\n    },\n\n    ensureLeft: function(prefix) {\n      var s = this.s;\n      if (s.indexOf(prefix) === 0) {\n        return this;\n      } else {\n        return new this.constructor(prefix + s);\n      }\n    },\n\n    ensureRight: function(suffix) {\n      var s = this.s;\n      if (this.endsWith(suffix))  {\n        return this;\n      } else {\n        return new this.constructor(s + suffix);\n      }\n    },\n\n    humanize: function() { //modified from underscore.string\n      if (this.s === null || this.s === undefined)\n        return new this.constructor(\'\')\n      var s = this.underscore().replace(/_id$/,\'\').replace(/_/g, \' \').trim().capitalize()\n      return new this.constructor(s)\n    },\n\n    isAlpha: function() {\n      return !/[^a-z\\xDF-\\xFF]|^$/.test(this.s.toLowerCase());\n    },\n\n    isAlphaNumeric: function() {\n      return !/[^0-9a-z\\xDF-\\xFF]/.test(this.s.toLowerCase());\n    },\n\n    isEmpty: function() {\n      return this.s === null || this.s === undefined ? true : /^[\\s\\xa0]*$/.test(this.s);\n    },\n\n    isLower: function() {\n      return this.isAlpha() && this.s.toLowerCase() === this.s;\n    },\n\n    isNumeric: function() {\n      return !/[^0-9]/.test(this.s);\n    },\n\n    isUpper: function() {\n      return this.isAlpha() && this.s.toUpperCase() === this.s;\n    },\n\n    left: function(N) {\n      if (N >= 0) {\n        var s = this.s.substr(0, N);\n        return new this.constructor(s);\n      } else {\n        return this.right(-N);\n      }\n    },\n\n    lines: function() { //convert windows newlines to unix newlines then convert to an Array of lines\n      return this.replaceAll(\'\\r\\n\', \'\\n\').s.split(\'\\n\');\n    },\n\n    pad: function(len, ch) { //https://github.com/component/pad\n      if (ch == null) ch = \' \';\n      if (this.s.length >= len) return new this.constructor(this.s);\n      len = len - this.s.length;\n      var left = Array(Math.ceil(len / 2) + 1).join(ch);\n      var right = Array(Math.floor(len / 2) + 1).join(ch);\n      return new this.constructor(left + this.s + right);\n    },\n\n    padLeft: function(len, ch) { //https://github.com/component/pad\n      if (ch == null) ch = \' \';\n      if (this.s.length >= len) return new this.constructor(this.s);\n      return new this.constructor(Array(len - this.s.length + 1).join(ch) + this.s);\n    },\n\n    padRight: function(len, ch) { //https://github.com/component/pad\n      if (ch == null) ch = \' \';\n      if (this.s.length >= len) return new this.constructor(this.s);\n      return new this.constructor(this.s + Array(len - this.s.length + 1).join(ch));\n    },\n\n    parseCSV: function(delimiter, qualifier, escape, lineDelimiter) { //try to parse no matter what\n      delimiter = delimiter || \',\';\n      escape = escape || \'\\\\\'\n      if (typeof qualifier == \'undefined\')\n        qualifier = \'"\';\n\n      var i = 0, fieldBuffer = [], fields = [], len = this.s.length, inField = false, inUnqualifiedString = false, self = this;\n      var ca = function(i){return self.s.charAt(i)};\n      if (typeof lineDelimiter !== \'undefined\') var rows = [];\n\n      if (!qualifier)\n        inField = true;\n\n      while (i < len) {\n        var current = ca(i);\n        switch (current) {\n          case escape:\n            //fix for issues #32 and #35\n            if (inField && ((escape !== qualifier) || ca(i+1) === qualifier)) {\n              i += 1;\n              fieldBuffer.push(ca(i));\n              break;\n            }\n            if (escape !== qualifier) break;\n          case qualifier:\n            inField = !inField;\n            break;\n          case delimiter:\n            if(inUnqualifiedString) {\n              inField=false;\n              inUnqualifiedString=false;\n            }\n            if (inField && qualifier)\n              fieldBuffer.push(current);\n            else {\n              fields.push(fieldBuffer.join(\'\'))\n              fieldBuffer.length = 0;\n            }\n            break;\n          case lineDelimiter:\n            if(inUnqualifiedString) {\n              inField=false;\n              inUnqualifiedString=false;\n              fields.push(fieldBuffer.join(\'\'))\n              rows.push(fields);\n              fields = [];\n              fieldBuffer.length = 0;\n            }\n            else if (inField) {\n              fieldBuffer.push(current);\n            } else {\n              if (rows) {\n                fields.push(fieldBuffer.join(\'\'))\n                rows.push(fields);\n                fields = [];\n                fieldBuffer.length = 0;\n              }\n            }\n            break;\n          case \' \':\n            if (inField)\n              fieldBuffer.push(current);\n            break;\n          default:\n            if (inField)\n              fieldBuffer.push(current);\n            else if(current!==qualifier) {\n              fieldBuffer.push(current);\n              inField=true;\n              inUnqualifiedString=true;\n            }\n            break;\n        }\n        i += 1;\n      }\n\n      fields.push(fieldBuffer.join(\'\'));\n      if (rows) {\n        rows.push(fields);\n        return rows;\n      }\n      return fields;\n    },\n\n    replaceAll: function(ss, r) {\n      //var s = this.s.replace(new RegExp(ss, \'g\'), r);\n      var s = this.s.split(ss).join(r)\n      return new this.constructor(s);\n    },\n\n    splitLeft: function(sep, maxSplit, limit) {\n      return __webpack_require__(277)(this.s, sep, maxSplit, limit)\n    },\n\n    splitRight: function(sep, maxSplit, limit) {\n      return __webpack_require__(278)(this.s, sep, maxSplit, limit)\n    },\n\n    strip: function() {\n      var ss = this.s;\n      for(var i= 0, n=arguments.length; i<n; i++) {\n        ss = ss.split(arguments[i]).join(\'\');\n      }\n      return new this.constructor(ss);\n    },\n\n    stripLeft: function (chars) {\n      var regex;\n      var pattern;\n      var ss = ensureString(this.s);\n\n      if (chars === undefined) {\n        pattern = /^\\s+/g;\n      }\n      else {\n        regex = escapeRegExp(chars);\n        pattern = new RegExp("^[" + regex + "]+", "g");\n      }\n\n      return new this.constructor(ss.replace(pattern, ""));\n    },\n\n    stripRight: function (chars) {\n      var regex;\n      var pattern;\n      var ss = ensureString(this.s);\n\n      if (chars === undefined) {\n        pattern = /\\s+$/g;\n      }\n      else {\n        regex = escapeRegExp(chars);\n        pattern = new RegExp("[" + regex + "]+$", "g");\n      }\n\n      return new this.constructor(ss.replace(pattern, ""));\n    },\n\n    right: function(N) {\n      if (N >= 0) {\n        var s = this.s.substr(this.s.length - N, N);\n        return new this.constructor(s);\n      } else {\n        return this.left(-N);\n      }\n    },\n\n    setValue: function (s) {\n\t  initialize(this, s);\n\t  return this;\n    },\n\n    slugify: function() {\n      var sl = (new S(new S(this.s).latinise().s.replace(/[^\\w\\s-]/g, \'\').toLowerCase())).dasherize().s;\n      if (sl.charAt(0) === \'-\')\n        sl = sl.substr(1);\n      return new this.constructor(sl);\n    },\n\n    startsWith: function() {\n      var prefixes = Array.prototype.slice.call(arguments, 0);\n      for (var i = 0; i < prefixes.length; ++i) {\n        if (this.s.lastIndexOf(prefixes[i], 0) === 0) return true;\n      }\n      return false;\n    },\n\n    stripPunctuation: function() {\n      //return new this.constructor(this.s.replace(/[\\.,-\\/#!$%\\^&\\*;:{}=\\-_`~()]/g,""));\n      return new this.constructor(this.s.replace(/[^\\w\\s]|_/g, "").replace(/\\s+/g, " "));\n    },\n\n    stripTags: function() { //from sugar.js\n      var s = this.s, args = arguments.length > 0 ? arguments : [\'\'];\n      multiArgs(args, function(tag) {\n        s = s.replace(RegExp(\'<\\/?\' + tag + \'[^<>]*>\', \'gi\'), \'\');\n      });\n      return new this.constructor(s);\n    },\n\n    template: function(values, opening, closing) {\n      var s = this.s\n      var opening = opening || Export.TMPL_OPEN\n      var closing = closing || Export.TMPL_CLOSE\n\n      var open = opening.replace(/[-[\\]()*\\s]/g, "\\\\$&").replace(/\\$/g, \'\\\\$\')\n      var close = closing.replace(/[-[\\]()*\\s]/g, "\\\\$&").replace(/\\$/g, \'\\\\$\')\n      var r = new RegExp(open + \'(.+?)\' + close, \'g\')\n        //, r = /\\{\\{(.+?)\\}\\}/g\n      var matches = s.match(r) || [];\n\n      matches.forEach(function(match) {\n        var key = match.substring(opening.length, match.length - closing.length).trim();//chop {{ and }}\n        var value = typeof values[key] == \'undefined\' ? \'\' : values[key];\n        s = s.replace(match, value);\n      });\n      return new this.constructor(s);\n    },\n\n    times: function(n) {\n      return new this.constructor(new Array(n + 1).join(this.s));\n    },\n\n    titleCase: function() {\n      var s = this.s;\n      if (s) {\n        s = s.replace(/(^[a-z]| [a-z]|-[a-z]|_[a-z])/g,\n          function($1){\n            return $1.toUpperCase();\n          }\n        );\n      }\n      return new this.constructor(s);\n    },\n\n    toBoolean: function() {\n      if (typeof this.orig === \'string\') {\n        var s = this.s.toLowerCase();\n        return s === \'true\' || s === \'yes\' || s === \'on\' || s === \'1\';\n      } else\n        return this.orig === true || this.orig === 1;\n    },\n\n    toFloat: function(precision) {\n      var num = parseFloat(this.s)\n      if (precision)\n        return parseFloat(num.toFixed(precision))\n      else\n        return num\n    },\n\n    toInt: function() { //thanks Google\n      // If the string starts with \'0x\' or \'-0x\', parse as hex.\n      return /^\\s*-?0x/i.test(this.s) ? parseInt(this.s, 16) : parseInt(this.s, 10)\n    },\n\n    trim: function() {\n      var s;\n      if (typeof __nsp.trim === \'undefined\')\n        s = this.s.replace(/(^\\s*|\\s*$)/g, \'\')\n      else\n        s = this.s.trim()\n      return new this.constructor(s);\n    },\n\n    trimLeft: function() {\n      var s;\n      if (__nsp.trimLeft)\n        s = this.s.trimLeft();\n      else\n        s = this.s.replace(/(^\\s*)/g, \'\');\n      return new this.constructor(s);\n    },\n\n    trimRight: function() {\n      var s;\n      if (__nsp.trimRight)\n        s = this.s.trimRight();\n      else\n        s = this.s.replace(/\\s+$/, \'\');\n      return new this.constructor(s);\n    },\n\n    truncate: function(length, pruneStr) { //from underscore.string, author: github.com/rwz\n      var str = this.s;\n\n      length = ~~length;\n      pruneStr = pruneStr || \'...\';\n\n      if (str.length <= length) return new this.constructor(str);\n\n      var tmpl = function(c){ return c.toUpperCase() !== c.toLowerCase() ? \'A\' : \' \'; },\n        template = str.slice(0, length+1).replace(/.(?=\\W*\\w*$)/g, tmpl); // \'Hello, world\' -> \'HellAA AAAAA\'\n\n      if (template.slice(template.length-2).match(/\\w\\w/))\n        template = template.replace(/\\s*\\S+$/, \'\');\n      else\n        template = new S(template.slice(0, template.length-1)).trimRight().s;\n\n      return (template+pruneStr).length > str.length ? new S(str) : new S(str.slice(0, template.length)+pruneStr);\n    },\n\n    toCSV: function() {\n      var delim = \',\', qualifier = \'"\', escape = \'\\\\\', encloseNumbers = true, keys = false;\n      var dataArray = [];\n\n      function hasVal(it) {\n        return it !== null && it !== \'\';\n      }\n\n      if (typeof arguments[0] === \'object\') {\n        delim = arguments[0].delimiter || delim;\n        delim = arguments[0].separator || delim;\n        qualifier = arguments[0].qualifier || qualifier;\n        encloseNumbers = !!arguments[0].encloseNumbers;\n        escape = arguments[0].escape || escape;\n        keys = !!arguments[0].keys;\n      } else if (typeof arguments[0] === \'string\') {\n        delim = arguments[0];\n      }\n\n      if (typeof arguments[1] === \'string\')\n        qualifier = arguments[1];\n\n      if (arguments[1] === null)\n        qualifier = null;\n\n       if (this.orig instanceof Array)\n        dataArray  = this.orig;\n      else { //object\n        for (var key in this.orig)\n          if (this.orig.hasOwnProperty(key))\n            if (keys)\n              dataArray.push(key);\n            else\n              dataArray.push(this.orig[key]);\n      }\n\n      var rep = escape + qualifier;\n      var buildString = [];\n      for (var i = 0; i < dataArray.length; ++i) {\n        var shouldQualify = hasVal(qualifier)\n        if (typeof dataArray[i] == \'number\')\n          shouldQualify &= encloseNumbers;\n\n        if (shouldQualify)\n          buildString.push(qualifier);\n\n        if (dataArray[i] !== null && dataArray[i] !== undefined) {\n          var d = new S(dataArray[i]).replaceAll(qualifier, rep).s;\n          buildString.push(d);\n        } else\n          buildString.push(\'\')\n\n        if (shouldQualify)\n          buildString.push(qualifier);\n\n        if (delim)\n          buildString.push(delim);\n      }\n\n      //chop last delim\n      //console.log(buildString.length)\n      buildString.length = buildString.length - 1;\n      return new this.constructor(buildString.join(\'\'));\n    },\n\n    toString: function() {\n      return this.s;\n    },\n\n    //#modified from https://github.com/epeli/underscore.string\n    underscore: function() {\n      var s = this.trim().s.replace(/([a-z\\d])([A-Z]+)/g, \'$1_$2\').replace(/([A-Z\\d]+)([A-Z][a-z])/g,\'$1_$2\').replace(/[-\\s]+/g, \'_\').toLowerCase();\n      return new this.constructor(s);\n    },\n\n    unescapeHTML: function() { //from underscore.string\n      return new this.constructor(this.s.replace(/\\&([^;]+);/g, function(entity, entityCode){\n        var match;\n\n        if (entityCode in escapeChars) {\n          return escapeChars[entityCode];\n        } else if (match = entityCode.match(/^#x([\\da-fA-F]+)$/)) {\n          return String.fromCharCode(parseInt(match[1], 16));\n        } else if (match = entityCode.match(/^#(\\d+)$/)) {\n          return String.fromCharCode(~~match[1]);\n        } else {\n          return entity;\n        }\n      }));\n    },\n\n    valueOf: function() {\n      return this.s.valueOf();\n    },\n\n    //#Added a New Function called wrapHTML.\n    wrapHTML: function (tagName, tagAttrs) {\n      var s = this.s, el = (tagName == null) ? \'span\' : tagName, elAttr = \'\', wrapped = \'\';\n      if(typeof tagAttrs == \'object\') for(var prop in tagAttrs) elAttr += \' \' + prop + \'="\' +(new this.constructor(tagAttrs[prop])).escapeHTML() + \'"\';\n      s = wrapped.concat(\'<\', el, elAttr, \'>\', this, \'</\', el, \'>\');\n      return new this.constructor(s);\n    }\n  }\n\n  var methodsAdded = [];\n  function extendPrototype() {\n    for (var name in __sp) {\n      (function(name){\n        var func = __sp[name];\n        if (!__nsp.hasOwnProperty(name)) {\n          methodsAdded.push(name);\n          __nsp[name] = function() {\n            String.prototype.s = this;\n            return func.apply(this, arguments);\n          }\n        }\n      })(name);\n    }\n  }\n\n  function restorePrototype() {\n    for (var i = 0; i < methodsAdded.length; ++i)\n      delete String.prototype[methodsAdded[i]];\n    methodsAdded.length = 0;\n  }\n\n\n/*************************************\n/* Attach Native JavaScript String Properties\n/*************************************/\n\n  var nativeProperties = getNativeStringProperties();\n  for (var name in nativeProperties) {\n    (function(name) {\n      var stringProp = __nsp[name];\n      if (typeof stringProp == \'function\') {\n        //console.log(stringProp)\n        if (!__sp[name]) {\n          if (nativeProperties[name] === \'string\') {\n            __sp[name] = function() {\n              //console.log(name)\n              return new this.constructor(stringProp.apply(this, arguments));\n            }\n          } else {\n            __sp[name] = stringProp;\n          }\n        }\n      }\n    })(name);\n  }\n\n\n/*************************************\n/* Function Aliases\n/*************************************/\n\n  __sp.repeat = __sp.times;\n  __sp.include = __sp.contains;\n  __sp.toInteger = __sp.toInt;\n  __sp.toBool = __sp.toBoolean;\n  __sp.decodeHTMLEntities = __sp.decodeHtmlEntities //ensure consistent casing scheme of \'HTML\'\n\n\n//******************************************************************************\n// Set the constructor.  Without this, string.js objects are instances of\n// Object instead of S.\n//******************************************************************************\n\n  __sp.constructor = S;\n\n\n/*************************************\n/* Private Functions\n/*************************************/\n\n  function getNativeStringProperties() {\n    var names = getNativeStringPropertyNames();\n    var retObj = {};\n\n    for (var i = 0; i < names.length; ++i) {\n      var name = names[i];\n      if (name === \'to\' || name === \'toEnd\') continue;       // get rid of the shelljs prototype messup\n      var func = __nsp[name];\n      try {\n        var type = typeof func.apply(\'teststring\');\n        retObj[name] = type;\n      } catch (e) {}\n    }\n    return retObj;\n  }\n\n  function getNativeStringPropertyNames() {\n    var results = [];\n    if (Object.getOwnPropertyNames) {\n      results = Object.getOwnPropertyNames(__nsp);\n      results.splice(results.indexOf(\'valueOf\'), 1);\n      results.splice(results.indexOf(\'toString\'), 1);\n      return results;\n    } else { //meant for legacy cruft, this could probably be made more efficient\n      var stringNames = {};\n      var objectNames = [];\n      for (var name in String.prototype)\n        stringNames[name] = name;\n\n      for (var name in Object.prototype)\n        delete stringNames[name];\n\n      //stringNames[\'toString\'] = \'toString\'; //this was deleted with the rest of the object names\n      for (var name in stringNames) {\n        results.push(name);\n      }\n      return results;\n    }\n  }\n\n  function Export(str) {\n    return new S(str);\n  };\n\n  //attach exports to StringJSWrapper\n  Export.extendPrototype = extendPrototype;\n  Export.restorePrototype = restorePrototype;\n  Export.VERSION = VERSION;\n  Export.TMPL_OPEN = \'{{\';\n  Export.TMPL_CLOSE = \'}}\';\n  Export.ENTITIES = ENTITIES;\n\n\n\n/*************************************\n/* Exports\n/*************************************/\n\n  if (typeof module !== \'undefined\'  && typeof module.exports !== \'undefined\') {\n    module.exports = Export;\n\n  } else {\n\n    if(true) {\n      !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function() {\n        return Export;\n      }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));\n    } else {\n      window.S = Export;\n    }\n  }\n\n\n/*************************************\n/* 3rd Party Private Functions\n/*************************************/\n\n  //from sugar.js\n  function multiArgs(args, fn) {\n    var result = [], i;\n    for(i = 0; i < args.length; i++) {\n      result.push(args[i]);\n      if(fn) fn.call(args, args[i], i);\n    }\n    return result;\n  }\n\n  //from underscore.string\n  var escapeChars = {\n    lt: \'<\',\n    gt: \'>\',\n    quot: \'"\',\n    apos: "\'",\n    amp: \'&\'\n  };\n\n  function escapeRegExp (s) {\n    // most part from https://github.com/skulpt/skulpt/blob/ecaf75e69c2e539eff124b2ab45df0b01eaf2295/src/str.js#L242\n    var c;\n    var i;\n    var ret = [];\n    var re = /^[A-Za-z0-9]+$/;\n    s = ensureString(s);\n    for (i = 0; i < s.length; ++i) {\n      c = s.charAt(i);\n\n      if (re.test(c)) {\n        ret.push(c);\n      }\n      else {\n        if (c === "\\\\000") {\n          ret.push("\\\\000");\n        }\n        else {\n          ret.push("\\\\" + c);\n        }\n      }\n    }\n    return ret.join("");\n  }\n\n  function ensureString(string) {\n    return string == null ? \'\' : \'\' + string;\n  }\n\n  //from underscore.string\n  var reversedEscapeChars = {};\n  for(var key in escapeChars){ reversedEscapeChars[escapeChars[key]] = key; }\n\n  ENTITIES = {\n    "amp" : "&",\n    "gt" : ">",\n    "lt" : "<",\n    "quot" : "\\"",\n    "apos" : "\'",\n    "AElig" : 198,\n    "Aacute" : 193,\n    "Acirc" : 194,\n    "Agrave" : 192,\n    "Aring" : 197,\n    "Atilde" : 195,\n    "Auml" : 196,\n    "Ccedil" : 199,\n    "ETH" : 208,\n    "Eacute" : 201,\n    "Ecirc" : 202,\n    "Egrave" : 200,\n    "Euml" : 203,\n    "Iacute" : 205,\n    "Icirc" : 206,\n    "Igrave" : 204,\n    "Iuml" : 207,\n    "Ntilde" : 209,\n    "Oacute" : 211,\n    "Ocirc" : 212,\n    "Ograve" : 210,\n    "Oslash" : 216,\n    "Otilde" : 213,\n    "Ouml" : 214,\n    "THORN" : 222,\n    "Uacute" : 218,\n    "Ucirc" : 219,\n    "Ugrave" : 217,\n    "Uuml" : 220,\n    "Yacute" : 221,\n    "aacute" : 225,\n    "acirc" : 226,\n    "aelig" : 230,\n    "agrave" : 224,\n    "aring" : 229,\n    "atilde" : 227,\n    "auml" : 228,\n    "ccedil" : 231,\n    "eacute" : 233,\n    "ecirc" : 234,\n    "egrave" : 232,\n    "eth" : 240,\n    "euml" : 235,\n    "iacute" : 237,\n    "icirc" : 238,\n    "igrave" : 236,\n    "iuml" : 239,\n    "ntilde" : 241,\n    "oacute" : 243,\n    "ocirc" : 244,\n    "ograve" : 242,\n    "oslash" : 248,\n    "otilde" : 245,\n    "ouml" : 246,\n    "szlig" : 223,\n    "thorn" : 254,\n    "uacute" : 250,\n    "ucirc" : 251,\n    "ugrave" : 249,\n    "uuml" : 252,\n    "yacute" : 253,\n    "yuml" : 255,\n    "copy" : 169,\n    "reg" : 174,\n    "nbsp" : 160,\n    "iexcl" : 161,\n    "cent" : 162,\n    "pound" : 163,\n    "curren" : 164,\n    "yen" : 165,\n    "brvbar" : 166,\n    "sect" : 167,\n    "uml" : 168,\n    "ordf" : 170,\n    "laquo" : 171,\n    "not" : 172,\n    "shy" : 173,\n    "macr" : 175,\n    "deg" : 176,\n    "plusmn" : 177,\n    "sup1" : 185,\n    "sup2" : 178,\n    "sup3" : 179,\n    "acute" : 180,\n    "micro" : 181,\n    "para" : 182,\n    "middot" : 183,\n    "cedil" : 184,\n    "ordm" : 186,\n    "raquo" : 187,\n    "frac14" : 188,\n    "frac12" : 189,\n    "frac34" : 190,\n    "iquest" : 191,\n    "times" : 215,\n    "divide" : 247,\n    "OElig;" : 338,\n    "oelig;" : 339,\n    "Scaron;" : 352,\n    "scaron;" : 353,\n    "Yuml;" : 376,\n    "fnof;" : 402,\n    "circ;" : 710,\n    "tilde;" : 732,\n    "Alpha;" : 913,\n    "Beta;" : 914,\n    "Gamma;" : 915,\n    "Delta;" : 916,\n    "Epsilon;" : 917,\n    "Zeta;" : 918,\n    "Eta;" : 919,\n    "Theta;" : 920,\n    "Iota;" : 921,\n    "Kappa;" : 922,\n    "Lambda;" : 923,\n    "Mu;" : 924,\n    "Nu;" : 925,\n    "Xi;" : 926,\n    "Omicron;" : 927,\n    "Pi;" : 928,\n    "Rho;" : 929,\n    "Sigma;" : 931,\n    "Tau;" : 932,\n    "Upsilon;" : 933,\n    "Phi;" : 934,\n    "Chi;" : 935,\n    "Psi;" : 936,\n    "Omega;" : 937,\n    "alpha;" : 945,\n    "beta;" : 946,\n    "gamma;" : 947,\n    "delta;" : 948,\n    "epsilon;" : 949,\n    "zeta;" : 950,\n    "eta;" : 951,\n    "theta;" : 952,\n    "iota;" : 953,\n    "kappa;" : 954,\n    "lambda;" : 955,\n    "mu;" : 956,\n    "nu;" : 957,\n    "xi;" : 958,\n    "omicron;" : 959,\n    "pi;" : 960,\n    "rho;" : 961,\n    "sigmaf;" : 962,\n    "sigma;" : 963,\n    "tau;" : 964,\n    "upsilon;" : 965,\n    "phi;" : 966,\n    "chi;" : 967,\n    "psi;" : 968,\n    "omega;" : 969,\n    "thetasym;" : 977,\n    "upsih;" : 978,\n    "piv;" : 982,\n    "ensp;" : 8194,\n    "emsp;" : 8195,\n    "thinsp;" : 8201,\n    "zwnj;" : 8204,\n    "zwj;" : 8205,\n    "lrm;" : 8206,\n    "rlm;" : 8207,\n    "ndash;" : 8211,\n    "mdash;" : 8212,\n    "lsquo;" : 8216,\n    "rsquo;" : 8217,\n    "sbquo;" : 8218,\n    "ldquo;" : 8220,\n    "rdquo;" : 8221,\n    "bdquo;" : 8222,\n    "dagger;" : 8224,\n    "Dagger;" : 8225,\n    "bull;" : 8226,\n    "hellip;" : 8230,\n    "permil;" : 8240,\n    "prime;" : 8242,\n    "Prime;" : 8243,\n    "lsaquo;" : 8249,\n    "rsaquo;" : 8250,\n    "oline;" : 8254,\n    "frasl;" : 8260,\n    "euro;" : 8364,\n    "image;" : 8465,\n    "weierp;" : 8472,\n    "real;" : 8476,\n    "trade;" : 8482,\n    "alefsym;" : 8501,\n    "larr;" : 8592,\n    "uarr;" : 8593,\n    "rarr;" : 8594,\n    "darr;" : 8595,\n    "harr;" : 8596,\n    "crarr;" : 8629,\n    "lArr;" : 8656,\n    "uArr;" : 8657,\n    "rArr;" : 8658,\n    "dArr;" : 8659,\n    "hArr;" : 8660,\n    "forall;" : 8704,\n    "part;" : 8706,\n    "exist;" : 8707,\n    "empty;" : 8709,\n    "nabla;" : 8711,\n    "isin;" : 8712,\n    "notin;" : 8713,\n    "ni;" : 8715,\n    "prod;" : 8719,\n    "sum;" : 8721,\n    "minus;" : 8722,\n    "lowast;" : 8727,\n    "radic;" : 8730,\n    "prop;" : 8733,\n    "infin;" : 8734,\n    "ang;" : 8736,\n    "and;" : 8743,\n    "or;" : 8744,\n    "cap;" : 8745,\n    "cup;" : 8746,\n    "int;" : 8747,\n    "there4;" : 8756,\n    "sim;" : 8764,\n    "cong;" : 8773,\n    "asymp;" : 8776,\n    "ne;" : 8800,\n    "equiv;" : 8801,\n    "le;" : 8804,\n    "ge;" : 8805,\n    "sub;" : 8834,\n    "sup;" : 8835,\n    "nsub;" : 8836,\n    "sube;" : 8838,\n    "supe;" : 8839,\n    "oplus;" : 8853,\n    "otimes;" : 8855,\n    "perp;" : 8869,\n    "sdot;" : 8901,\n    "lceil;" : 8968,\n    "rceil;" : 8969,\n    "lfloor;" : 8970,\n    "rfloor;" : 8971,\n    "lang;" : 9001,\n    "rang;" : 9002,\n    "loz;" : 9674,\n    "spades;" : 9824,\n    "clubs;" : 9827,\n    "hearts;" : 9829,\n    "diams;" : 9830\n  }\n\n\n}).call(this);\n\n\n/*****************\n ** WEBPACK FOOTER\n ** ./~/string/lib/string.js\n ** module id = 95\n ** module chunks = 15 20\n **/\n//# sourceURL=webpack:///./~/string/lib/string.js?');
},110:function(module,exports,__webpack_require__){eval('/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require("/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-api/modules/index.js"), RootInstanceProvider = require("/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js"), ReactMount = require("react/lib/ReactMount"), React = require("react"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n\'use strict\';\n\nObject.defineProperty(exports, \'__esModule\', {\n  value: true\n});\n\nfunction _interopRequire(obj) { return obj && obj.__esModule ? obj[\'default\'] : obj; }\n\nvar _LoggerOverview = __webpack_require__(897);\n\nexports.LoggerOverview = _interopRequire(_LoggerOverview);\n\nvar _LoggingSubsystem = __webpack_require__(898);\n\nexports.LoggingSubsystem = _interopRequire(_LoggingSubsystem);\n\nvar _LogLevelDropdown = __webpack_require__(894);\n\nexports.LogLevelDropdown = _interopRequire(_LogLevelDropdown);\n\nvar _LogLevelMetrics = __webpack_require__(895);\n\nexports.LogLevelMetrics = _interopRequire(_LogLevelMetrics);\n\nvar _LogLevelMetricsOverview = __webpack_require__(896);\n\nexports.LogLevelMetricsOverview = _interopRequire(_LogLevelMetricsOverview);\n\nvar _NodeLoggers = __webpack_require__(899);\n\nexports.NodeLoggers = _interopRequire(_NodeLoggers);\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require("/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js"); if (makeExportsHot(module, require("react"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error("Cannot not apply hot update to " + "index.jsx" + ": " + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/loggers/index.jsx\n ** module id = 110\n ** module chunks = 20\n **/\n//# sourceURL=webpack:///./src/components/loggers/index.jsx?')},276:function(module,exports){eval("function count(self, substr) {\n  var count = 0\n  var pos = self.indexOf(substr)\n\n  while (pos >= 0) {\n    count += 1\n    pos = self.indexOf(substr, pos + 1)\n  }\n\n  return count\n}\n\nmodule.exports = count\n\n/*****************\n ** WEBPACK FOOTER\n ** ./~/string/lib/_count.js\n ** module id = 276\n ** module chunks = 15 20\n **/\n//# sourceURL=webpack:///./~/string/lib/_count.js?")},277:function(module,exports){eval("function splitLeft(self, sep, maxSplit, limit) {\n\n  if (typeof maxSplit === 'undefined') {\n    var maxSplit = -1;\n  }\n\n  var splitResult = self.split(sep);\n  var splitPart1 = splitResult.slice(0, maxSplit);\n  var splitPart2 = splitResult.slice(maxSplit);\n\n  if (splitPart2.length === 0) {\n    splitResult = splitPart1;\n  } else {\n    splitResult = splitPart1.concat(splitPart2.join(sep));\n  }\n\n  if (typeof limit === 'undefined') {\n    return splitResult;\n  } else if (limit < 0) {\n    return splitResult.slice(limit);\n  } else {\n    return splitResult.slice(0, limit);\n  }\n\n}\n\nmodule.exports = splitLeft;\n\n\n/*****************\n ** WEBPACK FOOTER\n ** ./~/string/lib/_splitLeft.js\n ** module id = 277\n ** module chunks = 15 20\n **/\n//# sourceURL=webpack:///./~/string/lib/_splitLeft.js?")},278:function(module,exports){eval("function splitRight(self, sep, maxSplit, limit) {\n\n  if (typeof maxSplit === 'undefined') {\n    var maxSplit = -1;\n  }\n  if (typeof limit === 'undefined') {\n    var limit = 0;\n  }\n\n  var splitResult = [self];\n\n  for (var i = self.length-1; i >= 0; i--) {\n\n    if (\n      splitResult[0].slice(i).indexOf(sep) === 0 &&\n      (splitResult.length <= maxSplit || maxSplit === -1)\n    ) {\n      splitResult.splice(1, 0, splitResult[0].slice(i+sep.length)); // insert\n      splitResult[0] = splitResult[0].slice(0, i)\n    }\n  }\n\n  if (limit >= 0) {\n    return splitResult.slice(-limit);\n  } else {\n    return splitResult.slice(0, -limit);\n  }\n\n}\n\nmodule.exports = splitRight;\n\n\n/*****************\n ** WEBPACK FOOTER\n ** ./~/string/lib/_splitRight.js\n ** module id = 278\n ** module chunks = 15 20\n **/\n//# sourceURL=webpack:///./~/string/lib/_splitRight.js?")},894:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reflux = __webpack_require__(4);\n\nvar _reflux2 = _interopRequireDefault(_reflux);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _string = __webpack_require__(95);\n\nvar _string2 = _interopRequireDefault(_string);\n\nvar _injectionActionsProvider = __webpack_require__(6);\n\nvar _injectionActionsProvider2 = _interopRequireDefault(_injectionActionsProvider);\n\nvar _injectionStoreProvider = __webpack_require__(3);\n\nvar _injectionStoreProvider2 = _interopRequireDefault(_injectionStoreProvider);\n\nvar LoggersActions = _injectionActionsProvider2['default'].getActions('Loggers');\n\nvar LoggersStore = _injectionStoreProvider2['default'].getStore('Loggers');\n\nvar LogLevelDropdown = _react2['default'].createClass({\n  displayName: 'LogLevelDropdown',\n\n  propTypes: {\n    name: _react2['default'].PropTypes.string.isRequired,\n    nodeId: _react2['default'].PropTypes.string.isRequired,\n    subsystem: _react2['default'].PropTypes.object.isRequired\n  },\n  mixins: [_reflux2['default'].connect(LoggersStore)],\n  _changeLoglevel: function _changeLoglevel(loglevel) {\n    LoggersActions.setSubsystemLoggerLevel(this.props.nodeId, this.props.name, loglevel);\n  },\n  render: function render() {\n    var _this = this;\n\n    var _props = this.props;\n    var subsystem = _props.subsystem;\n    var nodeId = _props.nodeId;\n\n    var loglevels = this.state.availableLoglevels.map(function (loglevel) {\n      return _react2['default'].createElement(\n        _reactBootstrap.MenuItem,\n        { key: subsystem + '-' + nodeId + '-' + loglevel, active: subsystem.level === loglevel, onClick: function (evt) {\n            evt.preventDefault();_this._changeLoglevel(loglevel);\n          } },\n        (0, _string2['default'])(loglevel).capitalize().toString()\n      );\n    });\n    return _react2['default'].createElement(\n      _reactBootstrap.DropdownButton,\n      { id: 'loglevel', bsSize: 'xsmall', title: subsystem.level },\n      loglevels\n    );\n  }\n});\n\nexports['default'] = LogLevelDropdown;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"LogLevelDropdown.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/loggers/LogLevelDropdown.jsx\n ** module id = 894\n ** module chunks = 20\n **/\n//# sourceURL=webpack:///./src/components/loggers/LogLevelDropdown.jsx?")},895:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reflux = __webpack_require__(4);\n\nvar _reflux2 = _interopRequireDefault(_reflux);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _string = __webpack_require__(95);\n\nvar _string2 = _interopRequireDefault(_string);\n\nvar _numeral = __webpack_require__(20);\n\nvar _numeral2 = _interopRequireDefault(_numeral);\n\nvar _injectionActionsProvider = __webpack_require__(6);\n\nvar _injectionActionsProvider2 = _interopRequireDefault(_injectionActionsProvider);\n\nvar _injectionStoreProvider = __webpack_require__(3);\n\nvar _injectionStoreProvider2 = _interopRequireDefault(_injectionStoreProvider);\n\nvar _componentsCommon = __webpack_require__(5);\n\nvar MetricsActions = _injectionActionsProvider2['default'].getActions('Metrics');\n\nvar MetricsStore = _injectionStoreProvider2['default'].getStore('Metrics');\n\nvar LogLevelMetrics = _react2['default'].createClass({\n  displayName: 'LogLevelMetrics',\n\n  propTypes: {\n    nodeId: _react2['default'].PropTypes.string.isRequired,\n    loglevel: _react2['default'].PropTypes.string.isRequired\n  },\n  mixins: [_reflux2['default'].connect(MetricsStore)],\n  componentDidMount: function componentDidMount() {\n    MetricsActions.add(this.props.nodeId, this._metricName());\n  },\n  componentWillUnmount: function componentWillUnmount() {\n    MetricsActions.remove(this.props.nodeId, this._metricName());\n  },\n  _metricName: function _metricName() {\n    return 'org.apache.logging.log4j.core.Appender.' + this.props.loglevel;\n  },\n  render: function render() {\n    var _props = this.props;\n    var loglevel = _props.loglevel;\n    var nodeId = _props.nodeId;\n    var metrics = this.state.metrics;\n\n    var metricsDetails = undefined;\n    if (!metrics || !metrics[nodeId] || !metrics[nodeId][this._metricName()]) {\n      metricsDetails = _react2['default'].createElement(_componentsCommon.Spinner, null);\n    } else {\n      var metric = metrics[nodeId][this._metricName()].metric;\n      metricsDetails = _react2['default'].createElement(\n        'dl',\n        { className: 'loglevel-metrics-list' },\n        _react2['default'].createElement(\n          'dt',\n          null,\n          'Total written:'\n        ),\n        _react2['default'].createElement(\n          'dd',\n          null,\n          _react2['default'].createElement(\n            'span',\n            { className: 'loglevel-metric-total' },\n            metric.rate.total\n          )\n        ),\n        _react2['default'].createElement(\n          'dt',\n          null,\n          'Mean rate:'\n        ),\n        _react2['default'].createElement(\n          'dd',\n          null,\n          _react2['default'].createElement(\n            'span',\n            { className: 'loglevel-metric-mean' },\n            (0, _numeral2['default'])(metric.rate.mean).format('0.00')\n          ),\n          ' / second'\n        ),\n        _react2['default'].createElement(\n          'dt',\n          null,\n          '1 min rate:'\n        ),\n        _react2['default'].createElement(\n          'dd',\n          null,\n          _react2['default'].createElement(\n            'span',\n            { className: 'loglevel-metric-1min' },\n            (0, _numeral2['default'])(metric.rate.one_minute).format('0.00')\n          ),\n          ' / second'\n        )\n      );\n    }\n    return _react2['default'].createElement(\n      'div',\n      { className: 'loglevel-metrics-row' },\n      _react2['default'].createElement(\n        _reactBootstrap.Col,\n        { md: 4 },\n        _react2['default'].createElement(\n          'h3',\n          { className: 'u-light' },\n          'Level: ',\n          (0, _string2['default'])(loglevel).capitalize().toString()\n        ),\n        metricsDetails\n      )\n    );\n  }\n});\n\nexports['default'] = LogLevelMetrics;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"LogLevelMetrics.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/loggers/LogLevelMetrics.jsx\n ** module id = 895\n ** module chunks = 20\n **/\n//# sourceURL=webpack:///./src/components/loggers/LogLevelMetrics.jsx?")},896:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reflux = __webpack_require__(4);\n\nvar _reflux2 = _interopRequireDefault(_reflux);\n\nvar _injectionStoreProvider = __webpack_require__(3);\n\nvar _injectionStoreProvider2 = _interopRequireDefault(_injectionStoreProvider);\n\nvar _componentsLoggers = __webpack_require__(110);\n\nvar LoggersStore = _injectionStoreProvider2['default'].getStore('Loggers');\n\nvar LogLevelMetricsOverview = _react2['default'].createClass({\n  displayName: 'LogLevelMetricsOverview',\n\n  propTypes: {\n    nodeId: _react2['default'].PropTypes.string.isRequired\n  },\n  mixins: [_reflux2['default'].connect(LoggersStore)],\n  render: function render() {\n    var nodeId = this.props.nodeId;\n\n    var logLevelMetrics = this.state.availableLoglevels.map(function (loglevel) {\n      return _react2['default'].createElement(_componentsLoggers.LogLevelMetrics, { key: 'loglevel-metrics-' + nodeId + '-' + loglevel, nodeId: nodeId, loglevel: loglevel });\n    });\n    return _react2['default'].createElement(\n      'div',\n      { className: 'loglevel-metrics' },\n      logLevelMetrics\n    );\n  }\n});\n\nexports['default'] = LogLevelMetricsOverview;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"LogLevelMetricsOverview.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/loggers/LogLevelMetricsOverview.jsx\n ** module id = 896\n ** module chunks = 20\n **/\n//# sourceURL=webpack:///./src/components/loggers/LogLevelMetricsOverview.jsx?")},897:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reflux = __webpack_require__(4);\n\nvar _reflux2 = _interopRequireDefault(_reflux);\n\nvar _componentsCommon = __webpack_require__(5);\n\nvar _componentsLoggers = __webpack_require__(110);\n\nvar _injectionStoreProvider = __webpack_require__(3);\n\nvar _injectionStoreProvider2 = _interopRequireDefault(_injectionStoreProvider);\n\nvar LoggersStore = _injectionStoreProvider2['default'].getStore('Loggers');\n\nvar LoggerOverview = _react2['default'].createClass({\n  displayName: 'LoggerOverview',\n\n  mixins: [_reflux2['default'].connect(LoggersStore)],\n  render: function render() {\n    if (!this.state.loggers || !this.state.subsystems) {\n      return _react2['default'].createElement(_componentsCommon.Spinner, null);\n    }\n    var subsystems = this.state.subsystems;\n    var nodeLoggers = Object.keys(this.state.loggers).map(function (nodeId) {\n      return _react2['default'].createElement(_componentsLoggers.NodeLoggers, { key: 'node-loggers-' + nodeId,\n        nodeId: nodeId,\n        subsystems: subsystems[nodeId] ? subsystems[nodeId].subsystems : {} });\n    });\n    return _react2['default'].createElement(\n      'span',\n      null,\n      nodeLoggers\n    );\n  }\n});\n\nexports['default'] = LoggerOverview;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"LoggerOverview.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/loggers/LoggerOverview.jsx\n ** module id = 897\n ** module chunks = 20\n **/\n//# sourceURL=webpack:///./src/components/loggers/LoggerOverview.jsx?")},898:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _string = __webpack_require__(95);\n\nvar _string2 = _interopRequireDefault(_string);\n\nvar _componentsLoggers = __webpack_require__(110);\n\nvar LoggingSubsystem = _react2['default'].createClass({\n  displayName: 'LoggingSubsystem',\n\n  propTypes: {\n    name: _react2['default'].PropTypes.string.isRequired,\n    nodeId: _react2['default'].PropTypes.string.isRequired,\n    subsystem: _react2['default'].PropTypes.object.isRequired\n  },\n\n  render: function render() {\n    return _react2['default'].createElement(\n      'div',\n      { className: 'subsystem-row' },\n      _react2['default'].createElement(\n        _reactBootstrap.Col,\n        { md: 6, className: 'subsystem', style: { marginBottom: '10px' } },\n        _react2['default'].createElement(\n          'h3',\n          { className: 'u-light' },\n          'Subsystem: ',\n          (0, _string2['default'])(this.props.name).capitalize().toString(),\n          _react2['default'].createElement(\n            _reactBootstrap.ButtonGroup,\n            { className: 'pull-right' },\n            _react2['default'].createElement(_componentsLoggers.LogLevelDropdown, { nodeId: this.props.nodeId, name: this.props.name, subsystem: this.props.subsystem })\n          )\n        ),\n        this.props.subsystem.description,\n        _react2['default'].createElement('br', { style: { clear: 'both' } })\n      )\n    );\n  }\n});\n\nexports['default'] = LoggingSubsystem;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"LoggingSubsystem.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/loggers/LoggingSubsystem.jsx\n ** module id = 898\n ** module chunks = 20\n **/\n//# sourceURL=webpack:///./src/components/loggers/LoggingSubsystem.jsx?")},899:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _reflux = __webpack_require__(4);\n\nvar _reflux2 = _interopRequireDefault(_reflux);\n\nvar _reactBootstrap = __webpack_require__(2);\n\nvar _componentsCommon = __webpack_require__(5);\n\nvar _componentsLoggers = __webpack_require__(110);\n\nvar _injectionActionsProvider = __webpack_require__(6);\n\nvar _injectionActionsProvider2 = _interopRequireDefault(_injectionActionsProvider);\n\nvar _injectionStoreProvider = __webpack_require__(3);\n\nvar _injectionStoreProvider2 = _interopRequireDefault(_injectionStoreProvider);\n\nvar MetricsActions = _injectionActionsProvider2['default'].getActions('Metrics');\n\nvar MetricsStore = _injectionStoreProvider2['default'].getStore('Metrics');\n\nvar NodeLoggers = _react2['default'].createClass({\n  displayName: 'NodeLoggers',\n\n  propTypes: {\n    nodeId: _react2['default'].PropTypes.string.isRequired,\n    subsystems: _react2['default'].PropTypes.object.isRequired\n  },\n  mixins: [_reflux2['default'].connect(MetricsStore)],\n  getInitialState: function getInitialState() {\n    return { showDetails: false };\n  },\n  componentDidMount: function componentDidMount() {\n    MetricsActions.add(this.props.nodeId, this.metric_name);\n  },\n  componentWillUnmount: function componentWillUnmount() {\n    MetricsActions.remove(this.props.nodeId, this.metric_name);\n  },\n  metric_name: 'org.apache.logging.log4j.core.Appender.all',\n  _formatThroughput: function _formatThroughput() {\n    var metrics = this.state.metrics;\n    var nodeId = this.props.nodeId;\n\n    if (metrics && metrics[nodeId] && metrics[nodeId][this.metric_name]) {\n      var metric = metrics[nodeId][this.metric_name].metric;\n      return metric.rate.total;\n    }\n    return 'n/a';\n  },\n\n  render: function render() {\n    var _this = this;\n\n    var nodeId = this.props.nodeId;\n\n    var subsystems = Object.keys(this.props.subsystems).map(function (subsystem) {\n      return _react2['default'].createElement(_componentsLoggers.LoggingSubsystem, { name: subsystem,\n        nodeId: nodeId,\n        key: 'logging-subsystem-' + nodeId + '-' + subsystem,\n        subsystem: _this.props.subsystems[subsystem] });\n    });\n\n    var logLevelMetrics = _react2['default'].createElement(_componentsLoggers.LogLevelMetricsOverview, { nodeId: this.props.nodeId });\n    return _react2['default'].createElement(\n      _reactBootstrap.Row,\n      { className: 'row-sm log-writing-node content' },\n      _react2['default'].createElement(\n        _reactBootstrap.Col,\n        { md: 12 },\n        _react2['default'].createElement(\n          'div',\n          { style: { marginBottom: '20' } },\n          _react2['default'].createElement(\n            'div',\n            { className: 'pull-right' },\n            _react2['default'].createElement(\n              _reactBootstrap.Button,\n              { bsSize: 'sm', bsStyle: 'primary', className: 'trigger-log-level-metrics',\n                onClick: function () {\n                  return _this.setState({ showDetails: !_this.state.showDetails });\n                } },\n              _react2['default'].createElement('i', { className: 'fa fa-dashboard' }),\n              ' ',\n              this.state.showDetails ? 'Hide' : 'Show',\n              ' log level metrics'\n            )\n          ),\n          _react2['default'].createElement(\n            'h2',\n            null,\n            _react2['default'].createElement(_componentsCommon.LinkToNode, { nodeId: nodeId }),\n            _react2['default'].createElement(\n              'span',\n              { style: { fontSize: '12px' } },\n              ' Has written a total of ',\n              _react2['default'].createElement(\n                'strong',\n                null,\n                this._formatThroughput(),\n                ' internal log messages.'\n              )\n            )\n          )\n        ),\n        _react2['default'].createElement(\n          'div',\n          { className: 'subsystems' },\n          subsystems\n        ),\n        this.state.showDetails && logLevelMetrics\n      )\n    );\n  }\n});\n\nexports['default'] = NodeLoggers;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"NodeLoggers.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./src/components/loggers/NodeLoggers.jsx\n ** module id = 899\n ** module chunks = 20\n **/\n//# sourceURL=webpack:///./src/components/loggers/NodeLoggers.jsx?")},1014:function(module,exports,__webpack_require__){eval("/* REACT HOT LOADER */ if (false) { (function () { var ReactHotAPI = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-api/modules/index.js\"), RootInstanceProvider = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/RootInstanceProvider.js\"), ReactMount = require(\"react/lib/ReactMount\"), React = require(\"react\"); module.makeHot = module.hot.data ? module.hot.data.makeHot : ReactHotAPI(function () { return RootInstanceProvider.getRootInstances(ReactMount); }, React); })(); } try { (function () {\n\n'use strict';\n\nObject.defineProperty(exports, '__esModule', {\n  value: true\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _componentsCommon = __webpack_require__(5);\n\nvar _componentsLoggers = __webpack_require__(110);\n\nvar LoggersPage = _react2['default'].createClass({\n  displayName: 'LoggersPage',\n\n  render: function render() {\n    return _react2['default'].createElement(\n      'span',\n      null,\n      _react2['default'].createElement(\n        _componentsCommon.PageHeader,\n        { title: 'Logging' },\n        _react2['default'].createElement(\n          'span',\n          null,\n          'This section controls logging of the Graylog architecture and allows you to change log levels on the fly. Note that log levels are reset to their defaults after you restart the affected service.'\n        )\n      ),\n      _react2['default'].createElement(_componentsLoggers.LoggerOverview, null)\n    );\n  }\n});\n\nexports['default'] = LoggersPage;\nmodule.exports = exports['default'];\n\n/* REACT HOT LOADER */ }).call(this); } finally { if (false) { (function () { var foundReactClasses = module.hot.data && module.hot.data.foundReactClasses || false; if (module.exports && module.makeHot) { var makeExportsHot = require(\"/var/lib/jenkins/jobs/graylog-release/workspace/target/checkout/graylog2-web-interface/node_modules/react-hot-loader/makeExportsHot.js\"); if (makeExportsHot(module, require(\"react\"))) { foundReactClasses = true; } var shouldAcceptModule = true && foundReactClasses; if (shouldAcceptModule) { module.hot.accept(function (err) { if (err) { console.error(\"Cannot not apply hot update to \" + \"LoggersPage.jsx\" + \": \" + err.message); } }); } } module.hot.dispose(function (data) { data.makeHot = module.makeHot; data.foundReactClasses = foundReactClasses; }); })(); } }\n\n/*****************\n ** WEBPACK FOOTER\n ** ./~/react-hot-loader!./~/babel-loader!./src/pages/LoggersPage.jsx\n ** module id = 1014\n ** module chunks = 20\n **/\n//# sourceURL=webpack:///./src/pages/LoggersPage.jsx?./~/react-hot-loader!./~/babel-loader");
}});