
package org.graylog2.indexer.ranges;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.bson.types.ObjectId;
import org.joda.time.DateTime;
import org.mongojack.Id;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_MongoIndexRange extends MongoIndexRange {

  private final ObjectId id;
  private final String indexName;
  private final DateTime begin;
  private final DateTime end;
  private final DateTime calculatedAt;
  private final int calculationDuration;

  AutoValue_MongoIndexRange(
      @Nullable ObjectId id,
      String indexName,
      DateTime begin,
      DateTime end,
      DateTime calculatedAt,
      int calculationDuration) {
    this.id = id;
    if (indexName == null) {
      throw new NullPointerException("Null indexName");
    }
    this.indexName = indexName;
    if (begin == null) {
      throw new NullPointerException("Null begin");
    }
    this.begin = begin;
    if (end == null) {
      throw new NullPointerException("Null end");
    }
    this.end = end;
    if (calculatedAt == null) {
      throw new NullPointerException("Null calculatedAt");
    }
    this.calculatedAt = calculatedAt;
    this.calculationDuration = calculationDuration;
  }

  @Id
  @Nullable
  @JsonProperty(value = "_id")
  @Override
  public ObjectId id() {
    return id;
  }

  @JsonProperty(value = "index_name")
  @Override
  public String indexName() {
    return indexName;
  }

  @Override
  public DateTime begin() {
    return begin;
  }

  @Override
  public DateTime end() {
    return end;
  }

  @Override
  public DateTime calculatedAt() {
    return calculatedAt;
  }

  @JsonProperty(value = "took_ms")
  @Override
  public int calculationDuration() {
    return calculationDuration;
  }

  @Override
  public String toString() {
    return "MongoIndexRange{"
        + "id=" + id + ", "
        + "indexName=" + indexName + ", "
        + "begin=" + begin + ", "
        + "end=" + end + ", "
        + "calculatedAt=" + calculatedAt + ", "
        + "calculationDuration=" + calculationDuration
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MongoIndexRange) {
      MongoIndexRange that = (MongoIndexRange) o;
      return ((this.id == null) ? (that.id() == null) : this.id.equals(that.id()))
           && (this.indexName.equals(that.indexName()))
           && (this.begin.equals(that.begin()))
           && (this.end.equals(that.end()))
           && (this.calculatedAt.equals(that.calculatedAt()))
           && (this.calculationDuration == that.calculationDuration());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (id == null) ? 0 : this.id.hashCode();
    h *= 1000003;
    h ^= this.indexName.hashCode();
    h *= 1000003;
    h ^= this.begin.hashCode();
    h *= 1000003;
    h ^= this.end.hashCode();
    h *= 1000003;
    h ^= this.calculatedAt.hashCode();
    h *= 1000003;
    h ^= this.calculationDuration;
    return h;
  }

}
