
package org.graylog2.rest.resources.search.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.models.system.indexer.responses.IndexRangeSummary;
import org.joda.time.DateTime;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_SearchResponse extends SearchResponse {

  private final String query;
  private final String builtQuery;
  private final Set<IndexRangeSummary> usedIndices;
  private final List<ResultMessageSummary> messages;
  private final Set<String> fields;
  private final long time;
  private final long totalResults;
  private final DateTime from;
  private final DateTime to;

  AutoValue_SearchResponse(
      String query,
      String builtQuery,
      Set<IndexRangeSummary> usedIndices,
      List<ResultMessageSummary> messages,
      Set<String> fields,
      long time,
      long totalResults,
      DateTime from,
      DateTime to) {
    if (query == null) {
      throw new NullPointerException("Null query");
    }
    this.query = query;
    if (builtQuery == null) {
      throw new NullPointerException("Null builtQuery");
    }
    this.builtQuery = builtQuery;
    if (usedIndices == null) {
      throw new NullPointerException("Null usedIndices");
    }
    this.usedIndices = usedIndices;
    if (messages == null) {
      throw new NullPointerException("Null messages");
    }
    this.messages = messages;
    if (fields == null) {
      throw new NullPointerException("Null fields");
    }
    this.fields = fields;
    this.time = time;
    this.totalResults = totalResults;
    if (from == null) {
      throw new NullPointerException("Null from");
    }
    this.from = from;
    if (to == null) {
      throw new NullPointerException("Null to");
    }
    this.to = to;
  }

  @JsonProperty
  @Override
  public String query() {
    return query;
  }

  @JsonProperty
  @Override
  public String builtQuery() {
    return builtQuery;
  }

  @JsonProperty
  @Override
  public Set<IndexRangeSummary> usedIndices() {
    return usedIndices;
  }

  @JsonProperty
  @Override
  public List<ResultMessageSummary> messages() {
    return messages;
  }

  @JsonProperty
  @Override
  public Set<String> fields() {
    return fields;
  }

  @JsonProperty
  @Override
  public long time() {
    return time;
  }

  @JsonProperty
  @Override
  public long totalResults() {
    return totalResults;
  }

  @JsonProperty
  @Override
  public DateTime from() {
    return from;
  }

  @JsonProperty
  @Override
  public DateTime to() {
    return to;
  }

  @Override
  public String toString() {
    return "SearchResponse{"
        + "query=" + query + ", "
        + "builtQuery=" + builtQuery + ", "
        + "usedIndices=" + usedIndices + ", "
        + "messages=" + messages + ", "
        + "fields=" + fields + ", "
        + "time=" + time + ", "
        + "totalResults=" + totalResults + ", "
        + "from=" + from + ", "
        + "to=" + to
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof SearchResponse) {
      SearchResponse that = (SearchResponse) o;
      return (this.query.equals(that.query()))
           && (this.builtQuery.equals(that.builtQuery()))
           && (this.usedIndices.equals(that.usedIndices()))
           && (this.messages.equals(that.messages()))
           && (this.fields.equals(that.fields()))
           && (this.time == that.time())
           && (this.totalResults == that.totalResults())
           && (this.from.equals(that.from()))
           && (this.to.equals(that.to()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.query.hashCode();
    h *= 1000003;
    h ^= this.builtQuery.hashCode();
    h *= 1000003;
    h ^= this.usedIndices.hashCode();
    h *= 1000003;
    h ^= this.messages.hashCode();
    h *= 1000003;
    h ^= this.fields.hashCode();
    h *= 1000003;
    h ^= (this.time >>> 32) ^ this.time;
    h *= 1000003;
    h ^= (this.totalResults >>> 32) ^ this.totalResults;
    h *= 1000003;
    h ^= this.from.hashCode();
    h *= 1000003;
    h ^= this.to.hashCode();
    return h;
  }

}
