
package org.graylog2.rest.resources.streams.requests;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.graylog2.plugin.streams.Stream.MatchingType;
import org.graylog2.rest.resources.streams.rules.requests.CreateStreamRuleRequest;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_CreateStreamRequest extends CreateStreamRequest {

  private final String title;
  private final String description;
  private final List<CreateStreamRuleRequest> rules;
  private final String contentPack;
  private final MatchingType matchingType;

  AutoValue_CreateStreamRequest(
      String title,
      @Nullable String description,
      @Nullable List<CreateStreamRuleRequest> rules,
      @Nullable String contentPack,
      MatchingType matchingType) {
    if (title == null) {
      throw new NullPointerException("Null title");
    }
    this.title = title;
    this.description = description;
    this.rules = rules;
    this.contentPack = contentPack;
    if (matchingType == null) {
      throw new NullPointerException("Null matchingType");
    }
    this.matchingType = matchingType;
  }

  @JsonProperty
  @Override
  public String title() {
    return title;
  }

  @JsonProperty
  @Nullable
  @Override
  public String description() {
    return description;
  }

  @JsonProperty
  @Nullable
  @Override
  public List<CreateStreamRuleRequest> rules() {
    return rules;
  }

  @JsonProperty
  @Nullable
  @Override
  public String contentPack() {
    return contentPack;
  }

  @JsonProperty
  @Override
  public MatchingType matchingType() {
    return matchingType;
  }

  @Override
  public String toString() {
    return "CreateStreamRequest{"
        + "title=" + title + ", "
        + "description=" + description + ", "
        + "rules=" + rules + ", "
        + "contentPack=" + contentPack + ", "
        + "matchingType=" + matchingType
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof CreateStreamRequest) {
      CreateStreamRequest that = (CreateStreamRequest) o;
      return (this.title.equals(that.title()))
           && ((this.description == null) ? (that.description() == null) : this.description.equals(that.description()))
           && ((this.rules == null) ? (that.rules() == null) : this.rules.equals(that.rules()))
           && ((this.contentPack == null) ? (that.contentPack() == null) : this.contentPack.equals(that.contentPack()))
           && (this.matchingType.equals(that.matchingType()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.title.hashCode();
    h *= 1000003;
    h ^= (description == null) ? 0 : this.description.hashCode();
    h *= 1000003;
    h ^= (rules == null) ? 0 : this.rules.hashCode();
    h *= 1000003;
    h ^= (contentPack == null) ? 0 : this.contentPack.hashCode();
    h *= 1000003;
    h ^= this.matchingType.hashCode();
    return h;
  }

}
