/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.auditlog;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.graylog2.auditlog.AuditLogAppender;
import org.graylog2.auditlog.SuccessStatus;

public class AuditLogger {
    private final Collection<AuditLogAppender> appenders;

    @Inject
    public AuditLogger(Set<AuditLogAppender> appenders) {
        this.appenders = ImmutableSet.copyOf(appenders);
    }

    public void success(String subject, String action, String object) {
        this.success(subject, action, object, Collections.emptyMap());
    }

    public void success(String subject, String action, String object, Map<String, Object> context) {
        this.log(SuccessStatus.SUCCESS, subject, action, object, context);
    }

    public void failure(String subject, String action, String object) {
        this.failure(subject, action, object, Collections.emptyMap());
    }

    public void failure(String subject, String action, String object, Map<String, Object> context) {
        this.log(SuccessStatus.FAILURE, subject, action, object, context);
    }

    public void log(SuccessStatus successStatus, String subject, String action, String object, Map<String, Object> context) {
        for (AuditLogAppender appender : this.appenders) {
            if (!appender.enabled()) continue;
            appender.write(successStatus, subject, action, object, context);
        }
    }
}

