/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings;

import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.elasticsearch.client.Client;
import org.elasticsearch.node.Node;
import org.graylog2.Configuration;
import org.graylog2.alerts.AlertSender;
import org.graylog2.alerts.FormattedEmailAlertSender;
import org.graylog2.alerts.types.FieldContentValueAlertCondition;
import org.graylog2.alerts.types.FieldValueAlertCondition;
import org.graylog2.alerts.types.MessageCountAlertCondition;
import org.graylog2.auditlog.jersey.AuditLogDynamicFeature;
import org.graylog2.bindings.providers.BundleExporterProvider;
import org.graylog2.bindings.providers.BundleImporterProvider;
import org.graylog2.bindings.providers.ClusterEventBusProvider;
import org.graylog2.bindings.providers.DefaultSecurityManagerProvider;
import org.graylog2.bindings.providers.EsClientProvider;
import org.graylog2.bindings.providers.EsNodeProvider;
import org.graylog2.bindings.providers.MongoConnectionProvider;
import org.graylog2.bindings.providers.RulesEngineProvider;
import org.graylog2.bindings.providers.SystemJobFactoryProvider;
import org.graylog2.bindings.providers.SystemJobManagerProvider;
import org.graylog2.buffers.processors.ServerProcessBufferProcessor;
import org.graylog2.bundles.BundleService;
import org.graylog2.cluster.ClusterConfigServiceImpl;
import org.graylog2.dashboards.widgets.WidgetCacheTime;
import org.graylog2.database.MongoConnection;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.filters.FilterService;
import org.graylog2.filters.FilterServiceImpl;
import org.graylog2.grok.GrokPatternRegistry;
import org.graylog2.indexer.SetIndexReadOnlyJob;
import org.graylog2.indexer.healing.FixDeflectorByDeleteJob;
import org.graylog2.indexer.healing.FixDeflectorByMoveJob;
import org.graylog2.indexer.indices.jobs.OptimizeIndexJob;
import org.graylog2.indexer.indices.jobs.SetIndexReadOnlyAndCalculateRangeJob;
import org.graylog2.indexer.ranges.CreateNewSingleIndexRangeJob;
import org.graylog2.indexer.ranges.RebuildIndexRangesJob;
import org.graylog2.inputs.InputEventListener;
import org.graylog2.inputs.InputStateListener;
import org.graylog2.inputs.PersistedInputsImpl;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.RulesEngine;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.inject.Graylog2Module;
import org.graylog2.rest.NotFoundExceptionMapper;
import org.graylog2.rest.ScrollChunkWriter;
import org.graylog2.rest.ValidationExceptionMapper;
import org.graylog2.security.ldap.LdapConnector;
import org.graylog2.security.ldap.LdapSettingsImpl;
import org.graylog2.security.realm.LdapUserAuthenticator;
import org.graylog2.shared.buffers.processors.ProcessBufferProcessor;
import org.graylog2.shared.inputs.PersistedInputs;
import org.graylog2.shared.journal.JournalReaderModule;
import org.graylog2.shared.journal.KafkaJournalModule;
import org.graylog2.shared.journal.NoopJournalModule;
import org.graylog2.shared.metrics.jersey2.MetricsDynamicBinding;
import org.graylog2.shared.security.RestrictToMasterFeature;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.streams.StreamRouter;
import org.graylog2.streams.StreamRouterEngine;
import org.graylog2.system.activities.SystemMessageActivityWriter;
import org.graylog2.system.debug.ClusterDebugEventListener;
import org.graylog2.system.debug.LocalDebugEventListener;
import org.graylog2.system.jobs.SystemJobFactory;
import org.graylog2.system.jobs.SystemJobManager;
import org.graylog2.system.shutdown.GracefulShutdown;
import org.graylog2.system.stats.ClusterStatsModule;
import org.graylog2.users.RoleService;
import org.graylog2.users.RoleServiceImpl;
import org.graylog2.users.UserImpl;

public class ServerBindings
extends Graylog2Module {
    private final Configuration configuration;

    public ServerBindings(Configuration configuration) {
        this.configuration = configuration;
    }

    protected void configure() {
        this.bindInterfaces();
        this.bindSingletons();
        this.bindProviders();
        this.bindFactoryModules();
        this.bindDynamicFeatures();
        this.bindExceptionMappers();
        this.bindAdditionalJerseyComponents();
        this.bindEventBusListeners();
    }

    private void bindProviders() {
        this.bind(ClusterEventBus.class).toProvider(ClusterEventBusProvider.class).asEagerSingleton();
    }

    private void bindFactoryModules() {
        this.install(new FactoryModuleBuilder().build(RebuildIndexRangesJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(OptimizeIndexJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(SetIndexReadOnlyJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(CreateNewSingleIndexRangeJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(FixDeflectorByDeleteJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(FixDeflectorByMoveJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(SetIndexReadOnlyAndCalculateRangeJob.Factory.class));
        this.install(new FactoryModuleBuilder().build(LdapSettingsImpl.Factory.class));
        this.install(new FactoryModuleBuilder().build(FieldValueAlertCondition.Factory.class));
        this.install(new FactoryModuleBuilder().build(MessageCountAlertCondition.Factory.class));
        this.install(new FactoryModuleBuilder().build(FieldContentValueAlertCondition.Factory.class));
        this.install(new FactoryModuleBuilder().build(WidgetCacheTime.Factory.class));
        this.install(new FactoryModuleBuilder().build(UserImpl.Factory.class));
    }

    private void bindSingletons() {
        this.bind(Configuration.class).toInstance((Object)this.configuration);
        this.bind(BaseConfiguration.class).toInstance((Object)this.configuration);
        this.bind(MongoConnection.class).toProvider(MongoConnectionProvider.class);
        if (this.configuration.isMessageJournalEnabled()) {
            this.install((Module)new KafkaJournalModule());
            this.install((Module)new JournalReaderModule());
        } else {
            this.install((Module)new NoopJournalModule());
        }
        this.bind(Node.class).toProvider(EsNodeProvider.class).asEagerSingleton();
        this.bind(Client.class).toProvider(EsClientProvider.class).asEagerSingleton();
        this.bind(SystemJobManager.class).toProvider(SystemJobManagerProvider.class);
        this.bind(RulesEngine.class).toProvider(RulesEngineProvider.class);
        this.bind(LdapConnector.class).in(Scopes.SINGLETON);
        this.bind(LdapUserAuthenticator.class).in(Scopes.SINGLETON);
        this.bind(DefaultSecurityManager.class).toProvider(DefaultSecurityManagerProvider.class).asEagerSingleton();
        this.bind(SystemJobFactory.class).toProvider(SystemJobFactoryProvider.class);
        this.bind(GracefulShutdown.class).in(Scopes.SINGLETON);
        this.bind(BundleService.class).in(Scopes.SINGLETON);
        this.bind(BundleImporterProvider.class).in(Scopes.SINGLETON);
        this.bind(BundleExporterProvider.class).in(Scopes.SINGLETON);
        this.bind(ClusterStatsModule.class).asEagerSingleton();
        this.bind(ClusterConfigService.class).to(ClusterConfigServiceImpl.class).asEagerSingleton();
        this.bind(GrokPatternRegistry.class).in(Scopes.SINGLETON);
        this.bind(String[].class).annotatedWith((Annotation)Names.named((String)"RestControllerPackages")).toInstance((Object)new String[]{"org.graylog2.rest.resources", "org.graylog2.shared.rest.resources"});
    }

    private void bindInterfaces() {
        this.bind(AlertSender.class).to(FormattedEmailAlertSender.class);
        this.bind(StreamRouter.class);
        this.install(new FactoryModuleBuilder().implement(StreamRouterEngine.class, StreamRouterEngine.class).build(StreamRouterEngine.Factory.class));
        this.bind(FilterService.class).to(FilterServiceImpl.class).in(Scopes.SINGLETON);
        this.bind(ActivityWriter.class).to(SystemMessageActivityWriter.class);
        this.bind(PersistedInputs.class).to(PersistedInputsImpl.class);
        this.bind(ProcessBufferProcessor.class).to(ServerProcessBufferProcessor.class);
        this.bind(RoleService.class).to(RoleServiceImpl.class).in(Scopes.SINGLETON);
    }

    private void bindDynamicFeatures() {
        Multibinder<Class<? extends DynamicFeature>> dynamicFeatures = this.jerseyDynamicFeatureBinder();
        dynamicFeatures.addBinding().toInstance(MetricsDynamicBinding.class);
        dynamicFeatures.addBinding().toInstance(RestrictToMasterFeature.class);
        dynamicFeatures.addBinding().toInstance(AuditLogDynamicFeature.class);
    }

    private void bindExceptionMappers() {
        Multibinder<Class<? extends ExceptionMapper>> exceptionMappers = this.jerseyExceptionMapperBinder();
        exceptionMappers.addBinding().toInstance(NotFoundExceptionMapper.class);
        exceptionMappers.addBinding().toInstance(ValidationExceptionMapper.class);
    }

    private void bindAdditionalJerseyComponents() {
        this.jerseyAdditionalComponentsBinder().addBinding().toInstance(ScrollChunkWriter.class);
    }

    private void bindEventBusListeners() {
        this.bind(InputStateListener.class).asEagerSingleton();
        this.bind(InputEventListener.class).asEagerSingleton();
        this.bind(LocalDebugEventListener.class).asEagerSingleton();
        this.bind(ClusterDebugEventListener.class).asEagerSingleton();
    }
}

