/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.filters;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.graylog2.database.NotFoundException;
import org.graylog2.inputs.Input;
import org.graylog2.inputs.InputService;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.filters.MessageFilter;
import org.graylog2.plugin.inputs.Extractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractorFilter
implements MessageFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractorFilter.class);
    private static final String NAME = "Extractor";
    private Cache<String, List<Extractor>> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();
    private final InputService inputService;

    @Inject
    public ExtractorFilter(InputService inputService) {
        this.inputService = inputService;
    }

    @Override
    public boolean filter(Message msg) {
        if (msg.getSourceInputId() == null) {
            return false;
        }
        for (Extractor extractor : this.loadExtractors(msg.getSourceInputId())) {
            try {
                extractor.runExtractor(msg);
            }
            catch (Exception e) {
                extractor.incrementExceptions();
                LOG.error("Could not apply extractor \"" + extractor.getTitle() + "\" (id=" + extractor.getId() + ") " + "to message " + msg.getId(), (Throwable)e);
            }
        }
        return false;
    }

    private List<Extractor> loadExtractors(final String inputId) {
        try {
            return (List)this.cache.get((Object)inputId, (Callable)new Callable<List<Extractor>>(){

                @Override
                public List<Extractor> call() throws Exception {
                    LOG.debug("Re-loading extractors for input <{}> into cache.", (Object)inputId);
                    try {
                        Input input = ExtractorFilter.this.inputService.find(inputId);
                        ArrayList sorted = Lists.newArrayList(ExtractorFilter.this.inputService.getExtractors(input));
                        Collections.sort(sorted, new Comparator<Extractor>(){

                            @Override
                            public int compare(Extractor e1, Extractor e2) {
                                return e1.getOrder().intValue() - e2.getOrder().intValue();
                            }
                        });
                        return sorted;
                    }
                    catch (NotFoundException e) {
                        LOG.warn("Unable to load input: {}", (Object)e.getMessage());
                        return Collections.emptyList();
                    }
                }
            });
        }
        catch (ExecutionException e) {
            LOG.error("Could not load extractors into cache. Returning empty list.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPriority() {
        return 10;
    }
}

