/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.grok;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import oi.thekraken.grok.api.Grok;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.grok.GrokPatternsChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GrokPatternRegistry {
    private static final Logger log = LoggerFactory.getLogger(GrokPatternRegistry.class);
    private final GrokPatternService grokPatternService;
    private final AtomicReference<Set<GrokPattern>> patterns = new AtomicReference(Collections.emptySet());
    private final LoadingCache<String, Grok> grokCache;

    @Inject
    public GrokPatternRegistry(EventBus serverEventBus, GrokPatternService grokPatternService, @Named(value="daemonScheduler") ScheduledExecutorService daemonExecutor) {
        this.grokPatternService = grokPatternService;
        this.grokCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build(CacheLoader.asyncReloading((CacheLoader)new GrokReloader(), (Executor)daemonExecutor));
        this.reload();
        serverEventBus.register((Object)this);
    }

    @Subscribe
    public void grokPatternsChanged(GrokPatternsChangedEvent event) {
        this.reload();
    }

    public Grok cachedGrokForPattern(String pattern) {
        try {
            return (Grok)this.grokCache.get((Object)pattern);
        }
        catch (ExecutionException e) {
            log.error("Unable to load grok pattern {} into cache", (Object)pattern, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private void reload() {
        Set<GrokPattern> grokPatterns = this.grokPatternService.loadAll();
        this.patterns.set(grokPatterns);
        this.grokCache.invalidateAll();
    }

    public Set<GrokPattern> patterns() {
        return this.patterns.get();
    }

    private class GrokReloader
    extends CacheLoader<String, Grok> {
        private GrokReloader() {
        }

        public Grok load(@Nonnull String pattern) throws Exception {
            Grok grok = new Grok();
            for (GrokPattern grokPattern : GrokPatternRegistry.this.patterns()) {
                if (Strings.isNullOrEmpty((String)grokPattern.name) && !Strings.isNullOrEmpty((String)grokPattern.pattern)) continue;
                grok.addPattern(grokPattern.name, grokPattern.pattern);
            }
            grok.compile(pattern);
            return grok;
        }
    }
}

