/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.converters;

import java.util.Map;
import java.util.regex.Pattern;
import org.graylog2.ConfigurationException;
import org.graylog2.plugin.inputs.Converter;

public class SplitAndCountConverter
extends Converter {
    private final String splitBy;
    private final String splitByEscaped;

    public SplitAndCountConverter(Map<String, Object> config) throws ConfigurationException {
        super(Converter.Type.SPLIT_AND_COUNT, config);
        if (config.get("split_by") == null || ((String)config.get("split_by")).isEmpty()) {
            throw new ConfigurationException("Missing config [split_by].");
        }
        this.splitBy = (String)config.get("split_by");
        this.splitByEscaped = Pattern.quote((String)config.get("split_by"));
    }

    @Override
    public Object convert(String value) {
        if (value == null || value.isEmpty()) {
            return 0;
        }
        if (!value.contains(this.splitBy)) {
            return 0;
        }
        return value.split(this.splitByEscaped).length;
    }

    @Override
    public boolean buildsMultipleFields() {
        return false;
    }
}

