/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.log4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Booleans;

@Plugin(name="Memory", category="Core", elementType="appender", printObject=true)
public class MemoryAppender
extends AbstractAppender {
    private Buffer buffer;
    private int bufferSize;

    protected MemoryAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, int bufferSize) {
        super(name, filter, layout, ignoreExceptions);
        this.bufferSize = bufferSize;
        this.buffer = BufferUtils.synchronizedBuffer((Buffer)new CircularFifoBuffer(bufferSize));
    }

    @PluginFactory
    public static MemoryAppender createAppender(@PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="name") String name, @PluginAttribute(value="bufferSize", defaultInt=500) String bufferSize, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) String ignore) {
        if (name == null) {
            LOGGER.error("No name provided for MemoryAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        int size = Integer.parseInt(bufferSize);
        boolean ignoreExceptions = Booleans.parseBoolean((String)ignore, (boolean)true);
        return new MemoryAppender(name, filter, (Layout<? extends Serializable>)layout, ignoreExceptions, size);
    }

    public void append(LogEvent event) {
        this.buffer.add((Object)event);
    }

    public void stop() {
        super.stop();
        this.buffer.clear();
    }

    public List<LogEvent> getLogMessages(int max) {
        if (this.buffer == null) {
            throw new IllegalStateException("Cannot return log messages: Appender is not initialized.");
        }
        ArrayList<LogEvent> result = new ArrayList<LogEvent>(max);
        Object[] messages = this.buffer.toArray();
        for (int i = messages.length - 1; i >= 0 && i >= messages.length - max; --i) {
            result.add((LogEvent)messages[i]);
        }
        return result;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }
}

