/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.messageprocessors;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.graylog2.cluster.ClusterConfigChangedEvent;
import org.graylog2.messageprocessors.MessageProcessorsConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.messageprocessors.MessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedMessageProcessors
implements Iterable<MessageProcessor> {
    private static final Logger LOG = LoggerFactory.getLogger(OrderedMessageProcessors.class);
    private final Set<MessageProcessor> processors;
    private final ClusterConfigService clusterConfigService;
    private final AtomicReference<List<MessageProcessor>> sortedProcessors = new AtomicReference(Collections.emptyList());
    private Ordering<String> classNameOrdering;

    @Inject
    public OrderedMessageProcessors(Set<MessageProcessor> processors, ClusterConfigService clusterConfigService, EventBus eventBus) {
        this.processors = processors;
        this.clusterConfigService = clusterConfigService;
        eventBus.register((Object)this);
        this.classNameOrdering = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER);
        this.sortProcessorChain();
    }

    private void sortProcessorChain() {
        MessageProcessorsConfig config = this.clusterConfigService.get(MessageProcessorsConfig.class);
        if (config != null) {
            this.classNameOrdering = new ExplicitOrdering(config.processorOrder());
        }
        ImmutableList sortedCopy = this.classNameOrdering.onResultOf(mp -> mp.getClass().getCanonicalName()).immutableSortedCopy(this.processors);
        Collection enabledMessageProcessors = Collections2.filter((Collection)sortedCopy, mp -> config == null || !config.disabledProcessors().contains(mp.getClass().getCanonicalName()));
        LOG.debug("New active message processors: {}", (Object)enabledMessageProcessors);
        this.sortedProcessors.set((List<MessageProcessor>)ImmutableList.copyOf((Collection)enabledMessageProcessors));
    }

    @Subscribe
    public void handleOrderingUpdate(ClusterConfigChangedEvent event) {
        if (!MessageProcessorsConfig.class.getCanonicalName().equals(event.type())) {
            return;
        }
        this.sortProcessorChain();
    }

    @Override
    public Iterator<MessageProcessor> iterator() {
        return this.sortedProcessors.get().iterator();
    }

    private static class ExplicitOrdering
    extends Ordering<String> {
        private final Map<String, Integer> idxMap;

        public ExplicitOrdering(List<String> order) {
            this.idxMap = Maps.newHashMapWithExpectedSize((int)order.size());
            int idx = 0;
            for (String s : order) {
                this.idxMap.put(s, idx);
                ++idx;
            }
        }

        public int compare(String left, String right) {
            Integer leftIdx = this.idxMap.get(left);
            Integer rightIdx = this.idxMap.get(right);
            if (leftIdx != null && rightIdx != null) {
                return Integer.compare(leftIdx, rightIdx);
            }
            if (leftIdx == null && rightIdx == null) {
                return left.compareTo(right);
            }
            if (leftIdx == null) {
                return -1;
            }
            return 1;
        }
    }
}

