/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.SortedSet;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.auditlog.jersey.AuditLog;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.ranges.CreateNewSingleIndexRangeJob;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.indexer.ranges.RebuildIndexRangesJob;
import org.graylog2.rest.models.system.indexer.responses.IndexRangeSummary;
import org.graylog2.rest.models.system.indexer.responses.IndexRangesResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.system.jobs.SystemJobConcurrencyException;
import org.graylog2.system.jobs.SystemJobManager;
import org.hibernate.validator.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/IndexRanges", description="Index timeranges")
@Path(value="/system/indices/ranges")
public class IndexRangesResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRangesResource.class);
    private final IndexRangeService indexRangeService;
    private final RebuildIndexRangesJob.Factory rebuildIndexRangesJobFactory;
    private final CreateNewSingleIndexRangeJob.Factory singleIndexRangeJobFactory;
    private final Deflector deflector;
    private final SystemJobManager systemJobManager;

    @Inject
    public IndexRangesResource(IndexRangeService indexRangeService, RebuildIndexRangesJob.Factory rebuildIndexRangesJobFactory, CreateNewSingleIndexRangeJob.Factory singleIndexRangeJobFactory, Deflector deflector, SystemJobManager systemJobManager) {
        this.indexRangeService = indexRangeService;
        this.rebuildIndexRangesJobFactory = rebuildIndexRangesJobFactory;
        this.singleIndexRangeJobFactory = singleIndexRangeJobFactory;
        this.deflector = deflector;
        this.systemJobManager = systemJobManager;
    }

    @GET
    @Timed
    @ApiOperation(value="Get a list of all index ranges")
    @Produces(value={"application/json"})
    public IndexRangesResponse list() {
        SortedSet<IndexRange> all = this.indexRangeService.findAll();
        ArrayList ranges = Lists.newArrayListWithCapacity((int)all.size());
        for (IndexRange range : all) {
            if (!this.isPermitted("indexranges:read", range.indexName())) continue;
            IndexRangeSummary indexRange = IndexRangeSummary.create(range.indexName(), range.begin(), range.end(), range.calculatedAt(), range.calculationDuration());
            ranges.add(indexRange);
        }
        return IndexRangesResponse.create(ranges.size(), ranges);
    }

    @GET
    @Path(value="/{index: [a-z_0-9]+}")
    @Timed
    @ApiOperation(value="Show single index range")
    @Produces(value={"application/json"})
    public IndexRangeSummary show(@ApiParam(name="index", value="The name of the Graylog-managed Elasticsearch index", required=true) @PathParam(value="index") @NotEmpty String index) throws NotFoundException {
        if (!this.deflector.isGraylogIndex(index)) {
            throw new BadRequestException(index + " is not a Graylog-managed Elasticsearch index.");
        }
        this.checkPermission("indexranges:read", index);
        IndexRange indexRange = this.indexRangeService.get(index);
        return IndexRangeSummary.create(indexRange.indexName(), indexRange.begin(), indexRange.end(), indexRange.calculatedAt(), indexRange.calculationDuration());
    }

    @POST
    @Timed
    @Path(value="/rebuild")
    @RequiresPermissions(value={"indexranges:rebuild"})
    @ApiOperation(value="Rebuild/sync index range information.", notes="This triggers a systemjob that scans every index and stores meta information about what indices contain messages in what timeranges. It atomically overwrites already existing meta information.")
    @ApiResponses(value={@ApiResponse(code=202, message="Rebuild/sync systemjob triggered.")})
    @Produces(value={"application/json"})
    @AuditLog(action="recalculated", object="all index ranges")
    public Response rebuild() {
        RebuildIndexRangesJob rebuildJob = this.rebuildIndexRangesJobFactory.create(this.deflector);
        try {
            this.systemJobManager.submit(rebuildJob);
        }
        catch (SystemJobConcurrencyException e) {
            String errorMsg = "Concurrency level of this job reached: " + e.getMessage();
            LOG.error(errorMsg, (Throwable)e);
            throw new ForbiddenException(errorMsg);
        }
        return Response.accepted().build();
    }

    @POST
    @Timed
    @Path(value="/{index: [a-z_0-9]+}/rebuild")
    @ApiOperation(value="Rebuild/sync index range information.", notes="This triggers a system job that scans an index and stores meta information about what indices contain messages in what time ranges. It atomically overwrites already existing meta information.")
    @ApiResponses(value={@ApiResponse(code=202, message="Rebuild/sync system job triggered.")})
    @Produces(value={"application/json"})
    @AuditLog(action="recalculated", object="index range")
    public Response rebuildIndex(@ApiParam(name="index", value="The name of the Graylog-managed Elasticsearch index", required=true) @PathParam(value="index") @NotEmpty String index) {
        if (!this.deflector.isGraylogIndex(index)) {
            throw new BadRequestException(index + " is not a Graylog-managed Elasticsearch index.");
        }
        this.checkPermission("indexranges:rebuild", index);
        CreateNewSingleIndexRangeJob rebuildJob = this.singleIndexRangeJobFactory.create(this.deflector, index);
        try {
            this.systemJobManager.submit(rebuildJob);
        }
        catch (SystemJobConcurrencyException e) {
            LOG.error("Concurrency level of this job reached: " + e.getMessage());
            throw new ForbiddenException();
        }
        return Response.accepted().build();
    }
}

