/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.users;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.Configuration;
import org.graylog2.auditlog.jersey.AuditLog;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.rest.models.users.requests.ChangePasswordRequest;
import org.graylog2.rest.models.users.requests.ChangeUserRequest;
import org.graylog2.rest.models.users.requests.CreateUserRequest;
import org.graylog2.rest.models.users.requests.PermissionEditRequest;
import org.graylog2.rest.models.users.requests.Startpage;
import org.graylog2.rest.models.users.requests.UpdateUserPreferences;
import org.graylog2.rest.models.users.responses.Token;
import org.graylog2.rest.models.users.responses.TokenList;
import org.graylog2.rest.models.users.responses.UserList;
import org.graylog2.rest.models.users.responses.UserSummary;
import org.graylog2.security.AccessToken;
import org.graylog2.security.AccessTokenService;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.users.Role;
import org.graylog2.shared.users.Roles;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.RoleService;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Path(value="/users")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="Users", description="User accounts")
public class UsersResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(RestResource.class);
    private final UserService userService;
    private final AccessTokenService accessTokenService;
    private final RoleService roleService;
    private final Configuration configuration;

    @Inject
    public UsersResource(UserService userService, AccessTokenService accessTokenService, RoleService roleService, Configuration configuration) {
        this.userService = userService;
        this.accessTokenService = accessTokenService;
        this.roleService = roleService;
        this.configuration = configuration;
    }

    @GET
    @Path(value="{username}")
    @ApiOperation(value="Get user details", notes="The user's permissions are only included if a user asks for his own account or for users with the necessary permissions to edit permissions.")
    @ApiResponses(value={@ApiResponse(code=404, message="The user could not be found.")})
    public UserSummary get(@ApiParam(name="username", value="The username to return information for.", required=true) @PathParam(value="username") String username) {
        User user = this.userService.load(username);
        if (user == null) {
            throw new NotFoundException();
        }
        boolean allowedToSeePermissions = this.isPermitted("users:permissionsedit", username);
        boolean permissionsAllowed = this.getSubject().getPrincipal().toString().equals(username) || allowedToSeePermissions;
        return this.toUserResponse(user, permissionsAllowed);
    }

    @GET
    @RequiresPermissions(value={"users:list"})
    @ApiOperation(value="List all users", notes="The permissions assigned to the users are always included.")
    public UserList listUsers() {
        List<User> users = this.userService.loadAll();
        ArrayList resultUsers = Lists.newArrayListWithCapacity((int)(users.size() + 1));
        resultUsers.add(this.toUserResponse(this.userService.getAdminUser()));
        for (User user : users) {
            resultUsers.add(this.toUserResponse(user));
        }
        return UserList.create(resultUsers);
    }

    @POST
    @RequiresPermissions(value={"users:create"})
    @ApiOperation(value="Create a new user account.")
    @ApiResponses(value={@ApiResponse(code=400, message="Missing or invalid user details.")})
    @AuditLog(object="user")
    public Response create(@ApiParam(name="JSON body", value="Must contain username, full_name, email, password and a list of permissions.", required=true) @Valid @NotNull CreateUserRequest cr) throws ValidationException {
        Startpage startpage;
        Long sessionTimeoutMs;
        if (this.userService.load(cr.username()) != null) {
            String msg = "Cannot create user " + cr.username() + ". Username is already taken.";
            LOG.error(msg);
            throw new BadRequestException(msg);
        }
        User user = this.userService.create();
        user.setName(cr.username());
        user.setPassword(cr.password());
        user.setFullName(cr.fullName());
        user.setEmail(cr.email());
        user.setPermissions(cr.permissions());
        this.setUserRoles(cr.roles(), user);
        if (cr.timezone() != null) {
            user.setTimeZone(cr.timezone());
        }
        if ((sessionTimeoutMs = cr.sessionTimeoutMs()) != null) {
            user.setSessionTimeoutMs(sessionTimeoutMs);
        }
        if ((startpage = cr.startpage()) != null) {
            user.setStartpage(startpage.type(), startpage.id());
        }
        String id = this.userService.save(user);
        LOG.debug("Saved user {} with id {}", (Object)user.getName(), (Object)id);
        URI userUri = this.getUriBuilderToSelf().path(UsersResource.class).path("{username}").build(new Object[]{user.getName()});
        return Response.created((URI)userUri).build();
    }

    private void setUserRoles(@Nullable List<String> roles, User user) {
        if (roles != null) {
            try {
                Map<String, Role> nameMap = this.roleService.loadAllLowercaseNameMap();
                Iterable roleIds = Iterables.transform(roles, (Function)Roles.roleNameToIdFunction(nameMap));
                user.setRoleIds(Sets.newHashSet((Iterable)roleIds));
            }
            catch (org.graylog2.database.NotFoundException e) {
                throw new InternalServerErrorException((Throwable)e);
            }
        }
    }

    @PUT
    @Path(value="{username}")
    @ApiOperation(value="Modify user details.")
    @ApiResponses(value={@ApiResponse(code=400, message="Attempted to modify a read only user account (e.g. built-in or LDAP users)."), @ApiResponse(code=400, message="Missing or invalid user details.")})
    @AuditLog(object="user")
    public void changeUser(@ApiParam(name="username", value="The name of the user to modify.", required=true) @PathParam(value="username") String username, @ApiParam(name="JSON body", value="Updated user information.", required=true) @Valid @NotNull ChangeUserRequest cr) throws ValidationException {
        Long sessionTimeoutMs;
        String timezone;
        boolean permitted;
        this.checkPermission("users:edit", username);
        User user = this.userService.load(username);
        if (user == null) {
            throw new NotFoundException();
        }
        if (user.isReadOnly()) {
            throw new BadRequestException("Cannot modify readonly user " + username);
        }
        if (cr.email() != null) {
            user.setEmail(cr.email());
        }
        if (cr.fullName() != null) {
            user.setFullName(cr.fullName());
        }
        if ((permitted = this.isPermitted("users:permissionsedit", user.getName())) && cr.permissions() != null) {
            user.setPermissions(this.getEffectiveUserPermissions(user, cr.permissions()));
        }
        if (this.isPermitted("users:rolesedit", user.getName())) {
            this.setUserRoles(cr.roles(), user);
        }
        if ((timezone = cr.timezone()) == null) {
            user.setTimeZone((String)null);
        } else {
            try {
                if (timezone.isEmpty()) {
                    user.setTimeZone((String)null);
                } else {
                    DateTimeZone tz = DateTimeZone.forID((String)timezone);
                    user.setTimeZone(tz);
                }
            }
            catch (IllegalArgumentException e) {
                LOG.error("Invalid timezone '{}', ignoring it for user {}.", (Object)timezone, (Object)username);
            }
        }
        Startpage startpage = cr.startpage();
        if (startpage != null) {
            user.setStartpage(startpage.type(), startpage.id());
        }
        if (this.isPermitted("*") && (sessionTimeoutMs = cr.sessionTimeoutMs()) != null && sessionTimeoutMs != 0L) {
            user.setSessionTimeoutMs(sessionTimeoutMs);
        }
        this.userService.save(user);
    }

    @DELETE
    @Path(value="{username}")
    @RequiresPermissions(value={"users:edit"})
    @ApiOperation(value="Removes a user account.")
    @ApiResponses(value={@ApiResponse(code=400, message="When attempting to remove a read only user (e.g. built-in or LDAP user).")})
    @AuditLog(object="user")
    public void deleteUser(@ApiParam(name="username", value="The name of the user to delete.", required=true) @PathParam(value="username") String username) {
        if (this.userService.delete(username) == 0) {
            throw new NotFoundException();
        }
    }

    @PUT
    @Path(value="{username}/permissions")
    @RequiresPermissions(value={"users:permissionsedit"})
    @ApiOperation(value="Update a user's permission set.")
    @ApiResponses(value={@ApiResponse(code=400, message="Missing or invalid permission data.")})
    @AuditLog(object="user permissions")
    public void editPermissions(@ApiParam(name="username", value="The name of the user to modify.", required=true) @PathParam(value="username") String username, @ApiParam(name="JSON body", value="The list of permissions to assign to the user.", required=true) @Valid @NotNull PermissionEditRequest permissionRequest) throws ValidationException {
        User user = this.userService.load(username);
        if (user == null) {
            throw new NotFoundException();
        }
        user.setPermissions(this.getEffectiveUserPermissions(user, permissionRequest.permissions()));
        this.userService.save(user);
    }

    @PUT
    @Path(value="{username}/preferences")
    @ApiOperation(value="Update a user's preferences set.")
    @ApiResponses(value={@ApiResponse(code=400, message="Missing or invalid permission data.")})
    @AuditLog(object="user preferences")
    public void savePreferences(@ApiParam(name="username", value="The name of the user to modify.", required=true) @PathParam(value="username") String username, @ApiParam(name="JSON body", value="The map of preferences to assign to the user.", required=true) UpdateUserPreferences preferencesRequest) throws ValidationException {
        User user = this.userService.load(username);
        this.checkPermission("users:edit", username);
        if (user == null) {
            throw new NotFoundException();
        }
        user.setPreferences(preferencesRequest.preferences());
        this.userService.save(user);
    }

    @DELETE
    @Path(value="{username}/permissions")
    @RequiresPermissions(value={"users:permissionsedit"})
    @ApiOperation(value="Revoke all permissions for a user without deleting the account.")
    @ApiResponses(value={@ApiResponse(code=500, message="When saving the user failed.")})
    @AuditLog(object="user permissions")
    public void deletePermissions(@ApiParam(name="username", value="The name of the user to modify.", required=true) @PathParam(value="username") String username) throws ValidationException {
        User user = this.userService.load(username);
        if (user == null) {
            throw new NotFoundException();
        }
        user.setPermissions(Collections.emptyList());
        this.userService.save(user);
    }

    @PUT
    @Path(value="{username}/password")
    @ApiOperation(value="Update the password for a user.")
    @ApiResponses(value={@ApiResponse(code=204, message="The password was successfully updated. Subsequent requests must be made with the new password."), @ApiResponse(code=400, message="The new password is missing, or the old password is missing or incorrect."), @ApiResponse(code=403, message="The requesting user has insufficient privileges to update the password for the given user."), @ApiResponse(code=404, message="User does not exist.")})
    @AuditLog(object="user password")
    public void changePassword(@ApiParam(name="username", value="The name of the user whose password to change.", required=true) @PathParam(value="username") String username, @ApiParam(name="JSON body", value="The old and new passwords.", required=true) @Valid ChangePasswordRequest cr) throws ValidationException {
        User user = this.userService.load(username);
        if (user == null) {
            throw new NotFoundException();
        }
        if (!this.getSubject().isPermitted("users:passwordchange:" + user.getName())) {
            throw new ForbiddenException();
        }
        if (user.isExternalUser()) {
            String msg = "Cannot change password for LDAP user.";
            LOG.error("Cannot change password for LDAP user.");
            throw new ForbiddenException("Cannot change password for LDAP user.");
        }
        boolean checkOldPassword = true;
        if (this.getSubject().isPermitted("users:passwordchange:*")) {
            if (username.equals(this.getSubject().getPrincipal())) {
                LOG.debug("User {} is allowed to change the password of any user, but attempts to change own password. Must supply the old password.", this.getSubject().getPrincipal());
                checkOldPassword = true;
            } else {
                LOG.debug("User {} is allowed to change the password for any user, including {}, ignoring old password", this.getSubject().getPrincipal(), (Object)username);
                checkOldPassword = false;
            }
        }
        boolean changeAllowed = false;
        if (checkOldPassword) {
            if (user.isUserPassword(cr.oldPassword())) {
                changeAllowed = true;
            }
        } else {
            changeAllowed = true;
        }
        if (!changeAllowed) {
            throw new BadRequestException("Old password is missing or incorrect.");
        }
        user.setPassword(cr.password());
        this.userService.save(user);
    }

    @GET
    @Path(value="{username}/tokens")
    @RequiresPermissions(value={"users:tokenlist"})
    @ApiOperation(value="Retrieves the list of access tokens for a user")
    public TokenList listTokens(@ApiParam(name="username", required=true) @PathParam(value="username") String username) {
        User user = this._tokensCheckAndLoadUser(username);
        ImmutableList.Builder tokenList = ImmutableList.builder();
        for (AccessToken token : this.accessTokenService.loadAll(user.getName())) {
            tokenList.add((Object)Token.create(token.getName(), token.getToken(), token.getLastAccess()));
        }
        return TokenList.create((List<Token>)tokenList.build());
    }

    @POST
    @Path(value="{username}/tokens/{name}")
    @RequiresPermissions(value={"users:tokencreate"})
    @ApiOperation(value="Generates a new access token for a user")
    @AuditLog(object="user access token")
    public Token generateNewToken(@ApiParam(name="username", required=true) @PathParam(value="username") String username, @ApiParam(name="name", value="Descriptive name for this token (e.g. 'cronjob') ", required=true) @PathParam(value="name") String name) {
        User user = this._tokensCheckAndLoadUser(username);
        AccessToken accessToken = this.accessTokenService.create(user.getName(), name);
        return Token.create(accessToken.getName(), accessToken.getToken(), accessToken.getLastAccess());
    }

    @DELETE
    @RequiresPermissions(value={"users:tokenremove"})
    @Path(value="{username}/tokens/{token}")
    @ApiOperation(value="Removes a token for a user")
    @AuditLog(object="user access token")
    public void revokeToken(@ApiParam(name="username", required=true) @PathParam(value="username") String username, @ApiParam(name="access token", required=true) @PathParam(value="token") String token) {
        User user = this._tokensCheckAndLoadUser(username);
        AccessToken accessToken = this.accessTokenService.load(token);
        if (accessToken == null) {
            throw new NotFoundException();
        }
        this.accessTokenService.destroy(accessToken);
    }

    private User _tokensCheckAndLoadUser(String username) {
        User user = this.userService.load(username);
        if (user == null) {
            throw new NotFoundException("Unknown user " + username);
        }
        if (!this.getSubject().getPrincipal().equals(username)) {
            throw new ForbiddenException("Cannot access other people's tokens.");
        }
        return user;
    }

    private UserSummary toUserResponse(User user) {
        return this.toUserResponse(user, true);
    }

    private UserSummary toUserResponse(User user, boolean includePermissions) {
        Set<String> roleIds = user.getRoleIds();
        Set<Object> roleNames = Collections.emptySet();
        if (!roleIds.isEmpty() && (roleNames = this.userService.getRoleNames(user)).isEmpty()) {
            LOG.error("Unable to load role names for role IDs {} for user {}", roleIds, (Object)user);
        }
        return UserSummary.create(user.getId(), user.getName(), user.getEmail(), user.getFullName(), includePermissions ? this.userService.getPermissionsForUser(user) : Collections.emptyList(), user.getPreferences(), ((DateTimeZone)MoreObjects.firstNonNull((Object)user.getTimeZone(), (Object)DateTimeZone.UTC)).getID(), user.getSessionTimeoutMs(), user.isReadOnly(), user.isExternalUser(), user.getStartpage(), roleNames);
    }

    private List<String> getEffectiveUserPermissions(User user, List<String> permissions) {
        ArrayList effectivePermissions = Lists.newArrayList(permissions);
        effectivePermissions.removeAll(this.userService.getUserPermissionsFromRoles(user));
        return effectivePermissions;
    }
}

