/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.utilities;

import com.github.joschi.jadconfig.Converter;
import com.github.joschi.jadconfig.ParameterException;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.jboss.netty.handler.ipfilter.IpSubnet;

public class IPSubnetConverter
implements Converter<Set<IpSubnet>> {
    public Set<IpSubnet> convertFrom(String value) {
        HashSet<IpSubnet> converted = new HashSet<IpSubnet>();
        if (value != null) {
            Iterable subnets = Splitter.on((char)',').trimResults().split((CharSequence)value);
            for (String subnet : subnets) {
                try {
                    converted.add(new IpSubnet(subnet));
                }
                catch (UnknownHostException e) {
                    throw new ParameterException("Invalid subnet: " + subnet);
                }
            }
        }
        return converted;
    }

    public String convertTo(Set<IpSubnet> value) {
        if (value == null) {
            throw new ParameterException("Couldn't convert IP subnets <null> to string.");
        }
        return Joiner.on((String)",").skipNulls().join(value);
    }
}

