/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.auditlog;

import com.google.common.base.Joiner;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.auditlog.AuditLogAppender;
import org.graylog2.auditlog.SuccessStatus;

public class StdOutAppender
implements AuditLogAppender {
    private final boolean enabled;

    @Inject
    public StdOutAppender(@Named(value="auditlog_stdout_enabled") boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void write(SuccessStatus successStatus, String subject, String action, String object, Map<String, Object> context) {
        StringBuilder sb = new StringBuilder();
        sb.append("# AUDIT LOG ENTRY\n");
        sb.append("Status=").append((Object)successStatus).append('\n');
        sb.append("Timestamp=").append(ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME)).append('\n');
        sb.append("Subject=").append(subject).append('\n');
        sb.append("Action=").append(action).append('\n');
        sb.append("Object=").append(object).append('\n');
        sb.append("Context=");
        Joiner.on((String)",").withKeyValueSeparator(":").useForNull("null").appendTo(sb, context);
        System.out.println(sb);
    }
}

