/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.auditlog.jersey;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.graylog2.auditlog.AuditLogger;
import org.graylog2.auditlog.jersey.AuditLog;
import org.graylog2.rest.RestTools;
import org.jboss.netty.handler.ipfilter.IpSubnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=5000)
public class AuditLogFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AuditLogFilter.class);
    private final ResourceInfo resourceInfo;
    private final ExtendedUriInfo extendedUriInfo;
    private final Response response;
    private final AuditLogger auditLogger;
    private final Set<IpSubnet> trustedProxies;
    private final ObjectMapper objectMapper;
    private byte[] bufferedRequestEntitiy = null;

    @Inject
    public AuditLogFilter(@Context ResourceInfo resourceInfo, @Context ExtendedUriInfo extendedUriInfo, @Context Response response, AuditLogger auditLogger, @Named(value="trusted_proxies") Set<IpSubnet> trustedProxies, ObjectMapper objectMapper) {
        this.resourceInfo = Objects.requireNonNull(resourceInfo);
        this.extendedUriInfo = Objects.requireNonNull(extendedUriInfo);
        this.response = Objects.requireNonNull(response);
        this.auditLogger = Objects.requireNonNull(auditLogger);
        this.trustedProxies = Objects.requireNonNull(trustedProxies);
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Optional.ofNullable(this.resourceInfo.getResourceMethod()).filter((? super T method) -> MediaType.APPLICATION_JSON_TYPE.equals((Object)requestContext.getMediaType())).map(m -> m.getAnnotation(AuditLog.class)).ifPresent(auditLog -> {
            if (requestContext.hasEntity() && auditLog.captureRequestEntity()) {
                this.bufferedRequestEntitiy = this.bufferRequestEntity(requestContext);
            }
        });
    }

    @Nullable
    private byte[] bufferRequestEntity(ContainerRequestContext requestContext) {
        InputStream entityStream = requestContext.getEntityStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = null;
        try {
            ByteStreams.copy((InputStream)entityStream, (OutputStream)baos);
            bytes = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            requestContext.setEntityStream((InputStream)bais);
        }
        catch (IOException e) {
            LOG.debug("Error while buffering request entity", (Throwable)e);
        }
        return bytes;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Optional.ofNullable(this.resourceInfo.getResourceMethod()).map(m -> m.getAnnotation(AuditLog.class)).ifPresent(auditLog -> {
            Map<String, Object> responseEntity;
            Map<String, Object> requestEntity;
            String originalSubject = auditLog.subject();
            String subject = Strings.isNullOrEmpty((String)originalSubject) ? RestTools.getUserNameFromRequest(requestContext) : originalSubject;
            String originalAction = auditLog.action();
            String action = Strings.isNullOrEmpty((String)originalAction) ? this.getActionFromRequestMethod(requestContext.getMethod()) : originalAction;
            String object = auditLog.object();
            String remoteAddress = RestTools.getRemoteAddrFromRequest(this.response.getRequest(), this.trustedProxies);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("remote_address", remoteAddress);
            if (auditLog.captureRequestContext()) {
                MultivaluedMap queryParameters;
                MultivaluedMap pathParameters = this.extendedUriInfo.getPathParameters();
                if (!pathParameters.isEmpty()) {
                    context.put("path_params", pathParameters);
                }
                if (!(queryParameters = this.extendedUriInfo.getQueryParameters()).isEmpty()) {
                    context.put("query_params", queryParameters);
                }
            }
            if (this.bufferedRequestEntitiy != null && auditLog.captureRequestEntity() && (requestEntity = this.readRequestEntity(this.bufferedRequestEntitiy)) != null) {
                context.put("request_entity", requestEntity);
            }
            if (responseContext.hasEntity() && auditLog.captureResponseEntity() && (responseEntity = this.readResponseEntity(responseContext)) != null) {
                context.put("response_entity", responseEntity);
            }
            switch (responseContext.getStatusInfo().getFamily()) {
                case CLIENT_ERROR: 
                case SERVER_ERROR: {
                    this.auditLogger.failure(subject, action, object, context);
                    break;
                }
                default: {
                    this.auditLogger.success(subject, action, object, context);
                }
            }
        });
    }

    @Nullable
    private Map<String, Object> readRequestEntity(byte[] requestEntity) {
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        try {
            return (Map)this.objectMapper.readValue(requestEntity, (TypeReference)typeRef);
        }
        catch (IOException e) {
            LOG.debug("Couldn't capture request entity", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private Map<String, Object> readResponseEntity(ContainerResponseContext responseContext) {
        Class entityClass = responseContext.getEntityClass();
        boolean isJson = MediaType.APPLICATION_JSON_TYPE.equals((Object)responseContext.getMediaType());
        if (!entityClass.equals(Void.class) && !entityClass.equals(Void.TYPE) && isJson) {
            Object entity = responseContext.getEntity();
            TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
            return (Map)this.objectMapper.convertValue(entity, (TypeReference)typeRef);
        }
        return null;
    }

    private String getActionFromRequestMethod(String method) {
        switch (method) {
            case "GET": {
                return "read";
            }
            case "POST": {
                return "created";
            }
            case "PUT": {
                return "updated";
            }
            case "DELETE": {
                return "deleted";
            }
        }
        return "unknown";
    }
}

