/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.graylog2.Configuration;
import org.graylog2.configuration.AutoValue_ExposedConfiguration;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.joda.time.Period;

@JsonAutoDetect
public abstract class ExposedConfiguration {
    @JsonProperty(value="inputbuffer_processors")
    public abstract int inputBufferProcessors();

    @JsonProperty(value="processbuffer_processors")
    public abstract int processBufferProcessors();

    @JsonProperty(value="outputbuffer_processors")
    public abstract int outputBufferProcessors();

    @JsonProperty(value="processor_wait_strategy")
    public abstract String processorWaitStrategy();

    @JsonProperty(value="inputbuffer_wait_strategy")
    public abstract String inputBufferWaitStrategy();

    @JsonProperty(value="inputbuffer_ring_size")
    public abstract int inputBufferRingSize();

    @JsonProperty(value="ring_size")
    public abstract int ringSize();

    @JsonProperty(value="plugin_dir")
    public abstract String pluginDir();

    @JsonProperty(value="node_id_file")
    public abstract String nodeIdFile();

    @JsonProperty(value="allow_highlighting")
    public abstract boolean allowHighlighting();

    @JsonProperty(value="allow_leading_wildcard_searches")
    public abstract boolean allowLeadingWildcardSearches();

    @JsonProperty(value="rotation_strategy")
    public abstract String rotationStrategy();

    @JsonProperty(value="retention_strategy")
    public abstract String retentionStrategy();

    @JsonProperty(value="elasticsearch_max_docs_per_index")
    public abstract int maxDocsPerIndex();

    @JsonProperty(value="elasticsearch_max_size_per_index")
    public abstract long maxSizePerIndex();

    @JsonProperty(value="elasticsearch_max_time_per_index")
    public abstract Period maxTimePerIndex();

    @JsonProperty(value="elasticsearch_max_number_of_indices")
    public abstract int maxNumberOfIndices();

    @JsonProperty(value="elasticsearch_shards")
    public abstract int shards();

    @JsonProperty(value="elasticsearch_replicas")
    public abstract int replicas();

    @JsonProperty(value="stream_processing_timeout")
    public abstract long streamProcessingTimeout();

    @JsonProperty(value="stream_processing_max_faults")
    public abstract int streamProcessingMaxFaults();

    @JsonProperty(value="output_module_timeout")
    public abstract long outputModuleTimeout();

    @JsonProperty(value="stale_master_timeout")
    public abstract int staleMasterTimeout();

    @JsonProperty(value="disable_index_optimization")
    public abstract boolean disableIndexOptimization();

    @JsonProperty(value="index_optimization_max_num_segments")
    public abstract int indexOptimizationMaxSegments();

    @JsonProperty(value="gc_warning_threshold")
    public abstract String gcWarningThreshold();

    public static ExposedConfiguration create(Configuration configuration, ElasticsearchConfiguration esConfiguration) {
        return ExposedConfiguration.create(configuration.getInputbufferProcessors(), configuration.getProcessBufferProcessors(), configuration.getOutputBufferProcessors(), configuration.getProcessorWaitStrategy().getClass().getName(), configuration.getInputBufferWaitStrategy().getClass().getName(), configuration.getInputBufferRingSize(), configuration.getRingSize(), configuration.getPluginDir(), configuration.getNodeIdFile(), configuration.isAllowHighlighting(), configuration.isAllowLeadingWildcardSearches(), esConfiguration.getRotationStrategy(), esConfiguration.getRetentionStrategy(), esConfiguration.getMaxDocsPerIndex(), esConfiguration.getMaxSizePerIndex(), esConfiguration.getMaxTimePerIndex(), esConfiguration.getMaxNumberOfIndices(), esConfiguration.getShards(), esConfiguration.getReplicas(), configuration.getStreamProcessingTimeout(), configuration.getStreamProcessingMaxFaults(), configuration.getOutputModuleTimeout(), configuration.getStaleMasterTimeout(), esConfiguration.isDisableIndexOptimization(), esConfiguration.getIndexOptimizationMaxNumSegments(), configuration.getGcWarningThreshold().toString());
    }

    @JsonCreator
    public static ExposedConfiguration create(@JsonProperty(value="inputbuffer_processors") int inputBufferProcessors, @JsonProperty(value="processbuffer_processors") int processBufferProcessors, @JsonProperty(value="outputbuffer_processors") int outputBufferProcessors, @JsonProperty(value="processor_wait_strategy") String processorWaitStrategy, @JsonProperty(value="inputbuffer_wait_strategy") String inputBufferWaitStrategy, @JsonProperty(value="inputbuffer_ring_size") int inputBufferRingSize, @JsonProperty(value="ring_size") int ringSize, @JsonProperty(value="plugin_dir") String pluginDir, @JsonProperty(value="node_id_file") String nodeIdFile, @JsonProperty(value="allow_highlighting") boolean allowHighlighting, @JsonProperty(value="allow_leading_wildcard_searches") boolean allowLeadingWildcardSearches, @JsonProperty(value="rotation_strategy") String rotationStrategy, @JsonProperty(value="retention_strategy") String retentionStrategy, @JsonProperty(value="elasticsearch_max_docs_per_index") int maxDocsPerIndex, @JsonProperty(value="elasticsearch_max_size_per_index") long maxSizePerIndex, @JsonProperty(value="elasticsearch_max_time_per_index") Period maxTimePerIndex, @JsonProperty(value="elasticsearch_max_number_of_indices") int maxNumberOfIndices, @JsonProperty(value="elasticsearch_shards") int shards, @JsonProperty(value="elasticsearch_replicas") int replicas, @JsonProperty(value="stream_processing_timeout") long streamProcessingTimeout, @JsonProperty(value="stream_processing_max_faults") int streamProcessingMaxFaults, @JsonProperty(value="output_module_timeout") long outputModuleTimeout, @JsonProperty(value="stale_master_timeout") int staleMasterTimeout, @JsonProperty(value="disable_index_optimization") boolean disableIndexOptimization, @JsonProperty(value="index_optimization_max_num_segments") int indexOptimizationMaxSegments, @JsonProperty(value="gc_warning_threshold") String gcWarningThreshold) {
        return new AutoValue_ExposedConfiguration(inputBufferProcessors, processBufferProcessors, outputBufferProcessors, processorWaitStrategy, inputBufferWaitStrategy, inputBufferRingSize, ringSize, pluginDir, nodeIdFile, allowHighlighting, allowLeadingWildcardSearches, rotationStrategy, retentionStrategy, maxDocsPerIndex, maxSizePerIndex, maxTimePerIndex, maxNumberOfIndices, shards, replicas, streamProcessingTimeout, streamProcessingMaxFaults, outputModuleTimeout, staleMasterTimeout, disableIndexOptimization, indexOptimizationMaxSegments, gcWarningThreshold);
    }
}

