/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import java.util.Map;
import javax.inject.Inject;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class WidgetStrategyFactory {
    private final Map<String, WidgetStrategy.Factory<? extends WidgetStrategy>> widgetStrategyFactories;

    @Inject
    public WidgetStrategyFactory(Map<String, WidgetStrategy.Factory<? extends WidgetStrategy>> widgetStrategyFactories) {
        this.widgetStrategyFactories = widgetStrategyFactories;
    }

    public WidgetStrategy getWidgetForType(String typeName, Map<String, Object> config, TimeRange timeRange, String widgetId) throws InvalidWidgetConfigurationException {
        if (this.widgetStrategyFactories.containsKey(typeName)) {
            WidgetStrategy.Factory<? extends WidgetStrategy> factory = this.widgetStrategyFactories.get(typeName);
            return factory.create(config, timeRange, widgetId);
        }
        if (this.widgetStrategyFactories.containsKey(typeName.toUpperCase())) {
            WidgetStrategy.Factory<? extends WidgetStrategy> factory = this.widgetStrategyFactories.get(typeName.toUpperCase());
            return factory.create(config, timeRange, widgetId);
        }
        throw new IllegalArgumentException("Widget type <" + typeName + "> not found!");
    }
}

