/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets.strategies;

import com.google.common.base.Strings;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Map;
import org.graylog2.dashboards.widgets.strategies.ChartWidgetStrategy;
import org.graylog2.indexer.results.HistogramResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.plugin.dashboards.widgets.ComputationResult;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public class SearchResultChartWidgetStrategy
extends ChartWidgetStrategy {
    private final String query;
    private final Searches searches;
    private final TimeRange timeRange;

    @AssistedInject
    public SearchResultChartWidgetStrategy(Searches searches, @Assisted Map<String, Object> config, @Assisted TimeRange timeRange, @Assisted String widgetId) {
        super(config);
        this.searches = searches;
        this.timeRange = timeRange;
        this.query = this.getNonEmptyQuery((String)config.get("query"));
    }

    private String getNonEmptyQuery(String query) {
        if (Strings.isNullOrEmpty((String)query)) {
            return "*";
        }
        return query;
    }

    public String getQuery() {
        return this.query;
    }

    @Override
    public ComputationResult compute() {
        String filter = null;
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            filter = "streams:" + this.streamId;
        }
        HistogramResult histogram = this.searches.histogram(this.query, this.interval, filter, this.timeRange);
        return new ComputationResult(histogram.getResults(), histogram.took().millis(), histogram.getHistogramBoundaries());
    }

    public static interface Factory
    extends WidgetStrategy.Factory<SearchResultChartWidgetStrategy> {
        @Override
        public SearchResultChartWidgetStrategy create(Map<String, Object> var1, TimeRange var2, String var3);
    }
}

