/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.Objects;
import org.graylog2.database.MongoConnection;

public class MongoConnectionForTests
implements MongoConnection {
    private final Mongo mongoClient;
    private final DB db;
    private final MongoDatabase mongoDatabase;

    public MongoConnectionForTests(Mongo mongoClient, String dbName) {
        this.mongoClient = Objects.requireNonNull(mongoClient);
        this.db = mongoClient.getDB(dbName);
        this.mongoDatabase = null;
    }

    public MongoConnectionForTests(MongoClient mongoClient, String dbName) {
        this.mongoClient = (Mongo)Objects.requireNonNull(mongoClient);
        this.db = mongoClient.getDB(dbName);
        this.mongoDatabase = mongoClient.getDatabase(dbName);
    }

    @Override
    public Mongo connect() {
        return this.mongoClient;
    }

    @Override
    public DB getDatabase() {
        return this.db;
    }

    @Override
    public MongoDatabase getMongoDatabase() {
        if (this.mongoDatabase == null) {
            throw new IllegalStateException("MongoDatabase is unavailable.");
        }
        return this.mongoDatabase;
    }
}

