/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.decorators;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog2.decorators.DecoratorImpl;
import org.hibernate.validator.constraints.NotBlank;
import org.mongojack.ObjectId;

final class AutoValue_DecoratorImpl
extends DecoratorImpl {
    private final String id;
    private final String type;
    private final Map<String, Object> config;
    private final Optional<String> stream;
    private final int order;

    private AutoValue_DecoratorImpl(@Nullable String id, String type, Map<String, Object> config, Optional<String> stream, int order) {
        this.id = id;
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        if (config == null) {
            throw new NullPointerException("Null config");
        }
        this.config = config;
        if (stream == null) {
            throw new NullPointerException("Null stream");
        }
        this.stream = stream;
        this.order = order;
    }

    @Override
    @JsonProperty(value="_id")
    @ObjectId
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="type")
    @NotBlank
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="config")
    public Map<String, Object> config() {
        return this.config;
    }

    @Override
    @JsonProperty(value="stream")
    public Optional<String> stream() {
        return this.stream;
    }

    @Override
    @JsonProperty(value="order")
    public int order() {
        return this.order;
    }

    public String toString() {
        return "DecoratorImpl{id=" + this.id + ", " + "type=" + this.type + ", " + "config=" + this.config + ", " + "stream=" + this.stream + ", " + "order=" + this.order + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DecoratorImpl) {
            DecoratorImpl that = (DecoratorImpl)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.type.equals(that.type()) && this.config.equals(that.config()) && this.stream.equals(that.stream()) && this.order == that.order();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.id == null ? 0 : this.id.hashCode();
        h *= 1000003;
        h ^= this.type.hashCode();
        h *= 1000003;
        h ^= this.config.hashCode();
        h *= 1000003;
        h ^= this.stream.hashCode();
        h *= 1000003;
        return h ^= this.order;
    }

    @Override
    public DecoratorImpl.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends DecoratorImpl.Builder {
        private String id;
        private String type;
        private Map<String, Object> config;
        private Optional<String> stream;
        private Integer order;

        Builder() {
        }

        Builder(DecoratorImpl source) {
            this.id = source.id();
            this.type = source.type();
            this.config = source.config();
            this.stream = source.stream();
            this.order = source.order();
        }

        @Override
        public DecoratorImpl.Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @Override
        public DecoratorImpl.Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public DecoratorImpl.Builder config(Map<String, Object> config) {
            this.config = config;
            return this;
        }

        @Override
        public DecoratorImpl.Builder stream(Optional<String> stream) {
            this.stream = stream;
            return this;
        }

        @Override
        public DecoratorImpl.Builder order(int order) {
            this.order = order;
            return this;
        }

        @Override
        public DecoratorImpl build() {
            String missing = "";
            if (this.type == null) {
                missing = missing + " type";
            }
            if (this.config == null) {
                missing = missing + " config";
            }
            if (this.stream == null) {
                missing = missing + " stream";
            }
            if (this.order == null) {
                missing = missing + " order";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DecoratorImpl(this.id, this.type, this.config, this.stream, this.order);
        }
    }
}

