/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.decorators;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.decorators.DecoratorProcessor;
import org.graylog2.decorators.DecoratorResolver;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.decorators.SearchResponseDecorator;
import org.graylog2.rest.models.messages.responses.DecorationStats;
import org.graylog2.rest.models.messages.responses.ResultMessageSummary;
import org.graylog2.rest.resources.search.responses.SearchDecorationStats;
import org.graylog2.rest.resources.search.responses.SearchResponse;

public class DecoratorProcessorImpl
implements DecoratorProcessor {
    private final DecoratorResolver decoratorResolver;

    @Inject
    public DecoratorProcessorImpl(DecoratorResolver decoratorResolver) {
        this.decoratorResolver = decoratorResolver;
    }

    @Override
    public SearchResponse decorate(SearchResponse searchResponse, Optional<String> streamId) {
        List<SearchResponseDecorator> searchResponseDecorators = streamId.isPresent() ? this.decoratorResolver.searchResponseDecoratorsForStream(streamId.get()) : this.decoratorResolver.searchResponseDecoratorsForGlobal();
        Optional metaDecorator = searchResponseDecorators.stream().reduce((f, g) -> v -> (SearchResponse)g.apply((SearchResponse)f.apply(v)));
        if (metaDecorator.isPresent()) {
            Map originalMessages = searchResponse.messages().stream().collect(Collectors.toMap(message -> message.message().get("_id").toString(), Function.identity()));
            SearchResponse newSearchResponse = (SearchResponse)((SearchResponseDecorator)metaDecorator.get()).apply(searchResponse);
            Set<String> newFields = this.extractFields(newSearchResponse.messages());
            Set<String> addedFields = Sets.difference(newFields, searchResponse.fields()).stream().filter(field -> !Message.RESERVED_FIELDS.contains(field) && !field.equals("streams")).collect(Collectors.toSet());
            List<ResultMessageSummary> decoratedMessages = newSearchResponse.messages().stream().map(resultMessage -> {
                ResultMessageSummary originalMessage = (ResultMessageSummary)originalMessages.get(resultMessage.message().get("_id").toString());
                if (originalMessage != null) {
                    return resultMessage.toBuilder().decorationStats(DecorationStats.create(originalMessage.message(), resultMessage.message())).build();
                }
                return resultMessage;
            }).collect(Collectors.toList());
            return newSearchResponse.toBuilder().messages(decoratedMessages).fields(newFields).decorationStats(SearchDecorationStats.create(addedFields)).build();
        }
        return searchResponse;
    }

    private Set<String> extractFields(List<ResultMessageSummary> messages) {
        return messages.stream().map(message -> message.message().keySet()).reduce(new HashSet(), (set1, set2) -> {
            set1.addAll(set2);
            return set1;
        });
    }
}

