/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indices.jobs;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.system.jobs.SystemJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizeIndexJob
extends SystemJob {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizeIndexJob.class);
    public static final int MAX_CONCURRENCY = 1000;
    private final ActivityWriter activityWriter;
    private final String index;
    private final Indices indices;

    @AssistedInject
    public OptimizeIndexJob(Indices indices, ActivityWriter activityWriter, @Assisted String index) {
        this.indices = indices;
        this.activityWriter = activityWriter;
        this.index = index;
    }

    @Override
    public void execute() {
        String msg = "Optimizing index <" + this.index + ">.";
        this.activityWriter.write(new Activity(msg, OptimizeIndexJob.class));
        LOG.info(msg);
        this.indices.optimizeIndex(this.index);
    }

    @Override
    public void requestCancel() {
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public int maxConcurrency() {
        return 1000;
    }

    @Override
    public boolean providesProgress() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Optimizes an index for read performance.";
    }

    @Override
    public String getClassName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public String getInfo() {
        return "Optimizing index " + this.index + ".";
    }

    public static interface Factory {
        public OptimizeIndexJob create(String var1);
    }
}

