/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.ranges;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSortedSet;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.List;
import java.util.SortedSet;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.indexer.ranges.MongoIndexRange;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyMongoIndexRangeService
extends PersistedServiceImpl
implements IndexRangeService {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyMongoIndexRangeService.class);
    private static final String COLLECTION_NAME = "index_ranges";
    private static final String FIELD_START = "start";
    private static final String FIELD_INDEX = "index";

    @Inject
    public LegacyMongoIndexRangeService(MongoConnection mongoConnection) {
        super(mongoConnection);
    }

    @Override
    public IndexRange get(String index) throws NotFoundException {
        DBObject dbo = this.findOne((DBObject)new BasicDBObject(FIELD_INDEX, (Object)index), COLLECTION_NAME);
        if (dbo == null) {
            throw new NotFoundException("Index range for index <" + index + "> not found.");
        }
        try {
            return this.buildIndexRange(dbo);
        }
        catch (Exception e) {
            throw new NotFoundException("Index range for index <" + index + "> not valid.");
        }
    }

    private IndexRange buildIndexRange(DBObject dbo) {
        ObjectId id = (ObjectId)dbo.get("_id");
        String indexName = (String)dbo.get(FIELD_INDEX);
        DateTime begin = new DateTime(0L, DateTimeZone.UTC);
        DateTime end = new DateTime((long)((Integer)dbo.get(FIELD_START)).intValue() * 1000L, DateTimeZone.UTC);
        DateTime calculatedAt = new DateTime((long)((Integer)MoreObjects.firstNonNull((Object)((Integer)dbo.get("calculated_at")), (Object)0)).intValue() * 1000L, DateTimeZone.UTC);
        int calculationDuration = (Integer)MoreObjects.firstNonNull((Object)((Integer)dbo.get("took_ms")), (Object)0);
        return MongoIndexRange.create(id, indexName, begin, end, calculatedAt, calculationDuration);
    }

    @Override
    public SortedSet<IndexRange> find(DateTime begin, DateTime end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<IndexRange> findAll() {
        BasicDBList subQueries = new BasicDBList();
        subQueries.add((Object)new BasicDBObject(FIELD_INDEX, (Object)new BasicDBObject("$exists", (Object)true)));
        subQueries.add((Object)new BasicDBObject(FIELD_START, (Object)new BasicDBObject("$exists", (Object)true)));
        BasicDBObject query = new BasicDBObject("$and", (Object)subQueries);
        List<DBObject> result = this.query((DBObject)query, COLLECTION_NAME);
        ImmutableSortedSet.Builder indexRanges = ImmutableSortedSet.orderedBy(IndexRange.COMPARATOR);
        for (DBObject dbo : result) {
            try {
                indexRanges.add((Object)this.buildIndexRange(dbo));
            }
            catch (Exception e) {
                LOG.debug("Couldn't add index range to result set: " + dbo, (Throwable)e);
            }
        }
        return indexRanges.build();
    }

    @Override
    public void save(IndexRange indexRange) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexRange calculateRange(String index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexRange createUnknownRange(String index) {
        throw new UnsupportedOperationException();
    }

    public int delete(String index) {
        return this.destroy((DBObject)new BasicDBObject(FIELD_INDEX, (Object)index), COLLECTION_NAME);
    }
}

