/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.ranges;

import com.google.common.base.Stopwatch;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.concurrent.TimeUnit;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.system.jobs.SystemJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebuildIndexRangesJob
extends SystemJob {
    private static final Logger LOG = LoggerFactory.getLogger(RebuildIndexRangesJob.class);
    private static final int MAX_CONCURRENCY = 1;
    private volatile boolean cancelRequested = false;
    private volatile int indicesToCalculate = 0;
    private volatile int indicesCalculated = 0;
    protected final Deflector deflector;
    private final ActivityWriter activityWriter;
    protected final IndexRangeService indexRangeService;

    @AssistedInject
    public RebuildIndexRangesJob(@Assisted Deflector deflector, ActivityWriter activityWriter, IndexRangeService indexRangeService) {
        this.deflector = deflector;
        this.activityWriter = activityWriter;
        this.indexRangeService = indexRangeService;
    }

    @Override
    public void requestCancel() {
        this.cancelRequested = true;
    }

    @Override
    public int getProgress() {
        if (this.indicesToCalculate <= 0) {
            return 0;
        }
        return (int)Math.floor((float)this.indicesCalculated / (float)this.indicesToCalculate * 100.0f);
    }

    @Override
    public String getDescription() {
        return "Rebuilds index range information.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.info("Re-calculating index ranges.");
        String[] indices = this.deflector.getAllGraylogIndexNames();
        if (indices == null || indices.length == 0) {
            this.info("No indices, nothing to calculate.");
            return;
        }
        this.indicesToCalculate = indices.length;
        Stopwatch sw = Stopwatch.createStarted();
        String deflectorIndexName = this.deflector.getName();
        for (String index : indices) {
            if (deflectorIndexName.equals(index)) continue;
            if (this.cancelRequested) {
                this.info("Stop requested. Not calculating next index range, not updating ranges.");
                sw.stop();
                return;
            }
            try {
                IndexRange indexRange = this.indexRangeService.calculateRange(index);
                this.indexRangeService.save(indexRange);
                LOG.debug("Created ranges for index {}: {}", (Object)index, (Object)indexRange);
            }
            catch (Exception e) {
                LOG.info("Could not calculate range of index [" + index + "]. Skipping.", (Throwable)e);
            }
            finally {
                ++this.indicesCalculated;
            }
        }
        this.info("Done calculating index ranges for " + indices.length + " indices. Took " + sw.stop().elapsed(TimeUnit.MILLISECONDS) + "ms.");
    }

    protected void info(String what) {
        LOG.info(what);
        this.activityWriter.write(new Activity(what, RebuildIndexRangesJob.class));
    }

    @Override
    public boolean providesProgress() {
        return true;
    }

    @Override
    public boolean isCancelable() {
        return true;
    }

    @Override
    public int maxConcurrency() {
        return 1;
    }

    @Override
    public String getClassName() {
        return this.getClass().getCanonicalName();
    }

    public static interface Factory {
        public RebuildIndexRangesJob create(Deflector var1);
    }
}

