/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHits;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.results.IndexQueryResult;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.plugin.Message;

public class SearchResult
extends IndexQueryResult {
    private final long totalResults;
    private final List<ResultMessage> results;
    private final Set<String> fields;
    private final Set<IndexRange> usedIndices;

    public SearchResult(SearchHits searchHits, Set<IndexRange> usedIndices, String originalQuery, BytesReference builtQuery, TimeValue took) {
        super(originalQuery, builtQuery, took);
        this.results = this.buildResults(searchHits);
        this.fields = this.extractFields(this.results);
        this.totalResults = searchHits.getTotalHits();
        this.usedIndices = usedIndices;
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public List<ResultMessage> getResults() {
        return this.results;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    private Set<String> extractFields(List<ResultMessage> hits) {
        HashSet filteredFields = Sets.newHashSet();
        HashSet allFields = Sets.newHashSet();
        Iterator<ResultMessage> i = hits.iterator();
        while (i.hasNext()) {
            Message message = i.next().getMessage();
            allFields.addAll(message.getFieldNames());
            for (String field : message.getFieldNames()) {
                if (Message.RESERVED_FIELDS.contains((Object)field)) continue;
                filteredFields.add(field);
            }
        }
        if (allFields.contains("message")) {
            filteredFields.add("message");
        }
        if (allFields.contains("source")) {
            filteredFields.add("source");
        }
        filteredFields.remove("streams");
        filteredFields.remove("full_message");
        return filteredFields;
    }

    public Set<IndexRange> getUsedIndices() {
        return this.usedIndices;
    }
}

