/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation.strategies;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.graylog2.auditlog.AuditLogger;
import org.graylog2.indexer.Deflector;
import org.graylog2.indexer.NoTargetIndexException;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRotationStrategy
implements RotationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRotationStrategy.class);
    private final Deflector deflector;
    private final AuditLogger auditLogger;

    public AbstractRotationStrategy(Deflector deflector, AuditLogger auditLogger) {
        this.deflector = Objects.requireNonNull(deflector);
        this.auditLogger = Objects.requireNonNull(auditLogger);
    }

    @Nullable
    protected abstract Result shouldRotate(String var1);

    @Override
    public void rotate() {
        String indexName;
        String strategyName = this.getClass().getCanonicalName();
        try {
            indexName = this.deflector.getNewestTargetName();
        }
        catch (NoTargetIndexException e) {
            ImmutableMap auditLogContext = ImmutableMap.of((Object)"rotation_strategy", (Object)strategyName);
            this.auditLogger.failure("<system>", "initiated", "index rotation", (Map<String, Object>)auditLogContext);
            LOG.error("Could not find current deflector target. Aborting.", (Throwable)e);
            return;
        }
        ImmutableMap auditLogContext = ImmutableMap.of((Object)"index_name", (Object)indexName, (Object)"rotation_strategy", (Object)strategyName);
        Result rotate = this.shouldRotate(indexName);
        if (rotate == null) {
            LOG.error("Cannot perform rotation at this moment.");
            this.auditLogger.failure("<system>", "initiated", "index rotation", (Map<String, Object>)auditLogContext);
            return;
        }
        LOG.debug("Rotation strategy result: {}", (Object)rotate.getDescription());
        if (rotate.shouldRotate()) {
            LOG.info("Deflector index <{}> should be rotated, Pointing deflector to new index now!", (Object)indexName);
            this.deflector.cycle();
            this.auditLogger.success("<system>", "completed", "index rotation", (Map<String, Object>)auditLogContext);
        } else {
            LOG.debug("Deflector index <{}> should not be rotated. Not doing anything.", (Object)indexName);
        }
    }

    public static interface Result {
        public String getDescription();

        public boolean shouldRotate();
    }
}

