/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.initializers;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import javax.inject.Inject;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.shared.initializers.AbstractJerseyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebInterfaceService
extends AbstractJerseyService {
    private static final Logger LOG = LoggerFactory.getLogger(WebInterfaceService.class);
    private final BaseConfiguration configuration;

    @Inject
    public WebInterfaceService(ObjectMapper objectMapper, BaseConfiguration configuration, MetricRegistry metricRegistry) {
        super(Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), objectMapper, metricRegistry);
        this.configuration = configuration;
    }

    protected void startUp() throws Exception {
        String[] resources = new String[]{"org.graylog2.web.resources"};
        this.httpServer = this.setUp("web", this.configuration.getWebListenUri(), this.configuration.isWebEnableTls(), this.configuration.getWebTlsCertFile(), this.configuration.getWebTlsKeyFile(), this.configuration.getWebTlsKeyPassword(), this.configuration.getWebThreadPoolSize(), this.configuration.getWebMaxInitialLineLength(), this.configuration.getWebMaxHeaderSize(), this.configuration.isWebEnableGzip(), this.configuration.isWebEnableCors(), Collections.emptySet(), resources);
        this.httpServer.start();
        LOG.info("Started Web Interface at <{}>", (Object)this.configuration.getWebListenUri());
    }

    protected void shutDown() throws Exception {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            LOG.info("Shutting down Web Interface at <{}>", (Object)this.configuration.getWebListenUri());
            this.httpServer.shutdownNow();
        }
    }
}

