/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.github.joschi.jadconfig.util.Size;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.graylog2.plugin.LocalMetricRegistry;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.transports.NettyTransport;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.inputs.util.ThroughputCounter;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpTransport
extends NettyTransport {
    private static final Logger LOG = LoggerFactory.getLogger(UdpTransport.class);
    private final Executor workerExecutor;

    @AssistedInject
    public UdpTransport(@Assisted Configuration configuration, ThroughputCounter throughputCounter, LocalMetricRegistry localRegistry) {
        super(configuration, throughputCounter, localRegistry);
        this.workerExecutor = UdpTransport.executorService("worker", "udp-transport-worker-%d", localRegistry);
    }

    private static Executor executorService(String executorName, String threadNameFormat, LocalMetricRegistry localRegistry) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(threadNameFormat).build();
        return new InstrumentedExecutorService(Executors.newCachedThreadPool(threadFactory), (MetricRegistry)localRegistry, MetricRegistry.name(UdpTransport.class, (String[])new String[]{executorName, "executor-service"}));
    }

    @Override
    public Bootstrap getBootstrap() {
        ConnectionlessBootstrap bootstrap = new ConnectionlessBootstrap((ChannelFactory)new NioDatagramChannelFactory(this.workerExecutor));
        int recvBufferSize = Ints.saturatedCast((long)this.getRecvBufferSize());
        LOG.debug("Setting receive buffer size to {} bytes", (Object)recvBufferSize);
        bootstrap.setOption("receiveBufferSizePredictorFactory", (Object)new FixedReceiveBufferSizePredictorFactory(recvBufferSize));
        bootstrap.setOption("receiveBufferSize", (Object)recvBufferSize);
        return bootstrap;
    }

    @ConfigClass
    public static class Config
    extends NettyTransport.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest r = super.getRequestedConfiguration();
            int recvBufferSize = Ints.saturatedCast((long)Size.kilobytes((long)256L).toBytes());
            r.addField(ConfigurationRequest.Templates.recvBufferSize("recv_buffer_size", recvBufferSize));
            return r;
        }
    }

    @FactoryClass
    public static interface Factory
    extends Transport.Factory<UdpTransport> {
        @Override
        public UdpTransport create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

