/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.graylog2.Configuration;
import org.graylog2.indexer.cluster.Cluster;
import org.graylog2.indexer.messages.Messages;
import org.graylog2.outputs.ElasticSearchOutput;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.shared.journal.Journal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingBatchedESOutput
extends ElasticSearchOutput {
    private static final Logger log = LoggerFactory.getLogger(BlockingBatchedESOutput.class);
    private final Cluster cluster;
    private final int maxBufferSize;
    private final Timer processTime;
    private final Histogram batchSize;
    private final Meter bufferFlushes;
    private final Meter bufferFlushesRequested;
    private volatile List<Message> buffer;
    private static final AtomicInteger activeFlushThreads = new AtomicInteger(0);
    private final AtomicLong lastFlushTime = new AtomicLong();
    private final int outputFlushInterval;

    @AssistedInject
    public BlockingBatchedESOutput(MetricRegistry metricRegistry, Messages messages, Cluster cluster, Configuration serverConfiguration, Journal journal, @Assisted Stream stream, @Assisted org.graylog2.plugin.configuration.Configuration configuration) {
        this(metricRegistry, messages, cluster, serverConfiguration, journal);
    }

    @Inject
    public BlockingBatchedESOutput(MetricRegistry metricRegistry, Messages messages, Cluster cluster, Configuration serverConfiguration, Journal journal) {
        super(metricRegistry, messages, journal);
        this.cluster = cluster;
        this.maxBufferSize = serverConfiguration.getOutputBatchSize();
        this.outputFlushInterval = serverConfiguration.getOutputFlushInterval();
        this.processTime = metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"processTime"}));
        this.batchSize = metricRegistry.histogram(MetricRegistry.name(this.getClass(), (String[])new String[]{"batchSize"}));
        this.bufferFlushes = metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"bufferFlushes"}));
        this.bufferFlushesRequested = metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"bufferFlushesRequested"}));
        this.buffer = Lists.newArrayListWithCapacity((int)this.maxBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Message message) throws Exception {
        List<Message> flushBatch = null;
        BlockingBatchedESOutput blockingBatchedESOutput = this;
        synchronized (blockingBatchedESOutput) {
            this.buffer.add(message);
            if (this.buffer.size() >= this.maxBufferSize) {
                flushBatch = this.buffer;
                this.buffer = Lists.newArrayListWithCapacity((int)this.maxBufferSize);
            }
        }
        if (flushBatch != null) {
            this.flush(flushBatch);
        }
    }

    private void flush(List<Message> messages) {
        if (!this.cluster.isConnected() || !this.cluster.isDeflectorHealthy()) {
            try {
                this.cluster.waitForConnectedAndDeflectorHealthy();
            }
            catch (InterruptedException | TimeoutException e) {
                log.warn("Error while waiting for healthy Elasticsearch cluster. Not flushing.", (Throwable)e);
                return;
            }
        }
        if (messages.size() == 0) {
            return;
        }
        log.debug("Starting flushing {} messages, flush threads active {}", (Object)messages.size(), (Object)activeFlushThreads.incrementAndGet());
        try (Timer.Context ignored = this.processTime.time();){
            this.lastFlushTime.set(System.nanoTime());
            this.write(messages);
            this.batchSize.update(messages.size());
            this.bufferFlushes.mark();
        }
        catch (Exception e) {
            log.error("Unable to flush message buffer", (Throwable)e);
        }
        activeFlushThreads.decrementAndGet();
        log.debug("Flushing {} messages completed", (Object)messages.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceFlushIfTimedout() {
        List<Message> flushBatch;
        if (!this.cluster.isConnected() || !this.cluster.isDeflectorHealthy()) {
            log.debug("Cluster unavailable, but not blocking for periodic flush attempt. This will try again.");
            return;
        }
        if (this.lastFlushTime.get() != 0L && (long)this.outputFlushInterval > TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.lastFlushTime.get())) {
            return;
        }
        BlockingBatchedESOutput blockingBatchedESOutput = this;
        synchronized (blockingBatchedESOutput) {
            flushBatch = this.buffer;
            this.buffer = Lists.newArrayListWithCapacity((int)this.maxBufferSize);
        }
        if (flushBatch != null) {
            this.bufferFlushesRequested.mark();
            this.flush(flushBatch);
        }
    }

    public static class Descriptor
    extends ElasticSearchOutput.Descriptor {
        public Descriptor() {
            super("Blocking Batched Elasticsearch Output", false, "", "Elasticsearch Output with Batching (blocking)");
        }
    }

    public static class Config
    extends ElasticSearchOutput.Config {
    }

    public static interface Factory
    extends ElasticSearchOutput.Factory {
        @Override
        public BlockingBatchedESOutput create(Stream var1, org.graylog2.plugin.configuration.Configuration var2);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

