/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.codahale.metrics.MetricRegistry;
import javax.inject.Inject;
import org.graylog2.Configuration;
import org.graylog2.outputs.BlockingBatchedESOutput;
import org.graylog2.outputs.OutputRegistry;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedElasticSearchOutputFlushThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(BatchedElasticSearchOutputFlushThread.class);
    private final OutputRegistry outputRegistry;
    private final Configuration configuration;
    private MetricRegistry registry;

    @Inject
    public BatchedElasticSearchOutputFlushThread(OutputRegistry outputRegistry, Configuration configuration, MetricRegistry registry) {
        this.outputRegistry = outputRegistry;
        this.configuration = configuration;
        this.registry = registry;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return true;
    }

    @Override
    public boolean masterOnly() {
        return false;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return this.configuration.getOutputFlushInterval();
    }

    @Override
    public void doRun() {
        LOG.debug("Checking for outputs to flush ...");
        for (MessageOutput output : this.outputRegistry.getMessageOutputs()) {
            if (!(output instanceof BlockingBatchedESOutput)) continue;
            try {
                LOG.debug("Flushing output <{}>", (Object)output);
                ((BlockingBatchedESOutput)output).forceFlushIfTimedout();
            }
            catch (Exception e) {
                LOG.error("Caught exception while trying to flush output: {}", (Throwable)e);
            }
        }
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }
}

