/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.graylog2.cluster.UserPermissionMigrationState;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.shared.security.Permissions;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.RoleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserPermissionMigrationPeriodical
extends Periodical {
    private static final Logger log = LoggerFactory.getLogger(UserPermissionMigrationPeriodical.class);
    private final UserService userService;
    private final RoleService roleService;
    private final Permissions permissions;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public UserPermissionMigrationPeriodical(UserService userService, RoleService roleService, Permissions permissions, ClusterConfigService clusterConfigService) {
        this.userService = userService;
        this.roleService = roleService;
        this.permissions = permissions;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public void doRun() {
        List<User> users = this.userService.loadAll();
        String adminRoleId = this.roleService.getAdminRoleObjectId();
        String readerRoleId = this.roleService.getReaderRoleObjectId();
        for (User user : users) {
            if (user.isLocalAdmin()) {
                log.debug("Skipping local admin user.");
                continue;
            }
            HashSet fixedPermissions = Sets.newHashSet();
            HashSet fixedRoleIds = Sets.newHashSet(user.getRoleIds());
            HashSet permissionSet = Sets.newHashSet(user.getPermissions());
            boolean hasWildcardPermission = permissionSet.contains("*");
            if (hasWildcardPermission && !user.getRoleIds().contains(adminRoleId)) {
                fixedRoleIds.add(adminRoleId);
            }
            final Set<String> basePermissions = this.permissions.readerPermissions(user.getName());
            boolean hasCompleteReaderSet = permissionSet.containsAll(basePermissions);
            if (!user.getRoleIds().isEmpty() && hasCompleteReaderSet && hasWildcardPermission) {
                log.debug("Not migrating user {}, it has already been migrated.", (Object)user.getName());
                continue;
            }
            if (hasCompleteReaderSet && !user.getRoleIds().contains(readerRoleId)) {
                fixedRoleIds.add(readerRoleId);
            }
            ArrayList dashboardStreamPermissions = Lists.newArrayList((Iterable)Sets.filter((Set)permissionSet, (Predicate)new Predicate<String>(){

                public boolean apply(String permission) {
                    return !basePermissions.contains(permission) && !permission.equals("*");
                }
            }));
            fixedPermissions.addAll(this.permissions.userSelfEditPermissions(user.getName()));
            fixedPermissions.addAll(dashboardStreamPermissions);
            log.info("Migrating permissions to roles for user {} from permissions {} and roles {} to new permissions {} and roles {}", new Object[]{user.getName(), permissionSet, user.getRoleIds(), fixedPermissions, fixedRoleIds});
            user.setRoleIds(fixedRoleIds);
            user.setPermissions(Lists.newArrayList((Iterable)fixedPermissions));
            try {
                this.userService.save(user);
            }
            catch (ValidationException e) {
                log.error("Unable to migrate user permissions for user " + user.getName(), (Throwable)e);
            }
        }
        log.info("Marking user permission migration as done.");
        this.clusterConfigService.write(UserPermissionMigrationState.create(true));
    }

    @Override
    public boolean runsForever() {
        return true;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        UserPermissionMigrationState migrationState = this.clusterConfigService.getOrDefault(UserPermissionMigrationState.class, UserPermissionMigrationState.create(false));
        return !migrationState.migrationDone();
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return log;
    }
}

