/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.google.common.util.concurrent.Service;
import com.google.inject.Binder;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import java.util.Collections;
import java.util.Set;
import org.graylog2.auditlog.AuditLogAppender;
import org.graylog2.plugin.PluginConfigBean;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;
import org.graylog2.plugin.filters.MessageFilter;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.indexer.rotation.RotationStrategy;
import org.graylog2.plugin.inject.Graylog2Module;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.transports.Transport;
import org.graylog2.plugin.messageprocessors.MessageProcessor;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.plugin.security.PasswordAlgorithm;
import org.graylog2.plugin.security.PluginPermissions;

public abstract class PluginModule
extends Graylog2Module {
    public Set<? extends PluginConfigBean> getConfigBeans() {
        return Collections.emptySet();
    }

    protected void addMessageInput(Class<? extends MessageInput> messageInputClass) {
        this.installInput(this.inputsMapBinder(), messageInputClass);
    }

    protected <T extends MessageInput> void addMessageInput(Class<T> messageInputClass, Class<? extends MessageInput.Factory<T>> factoryClass) {
        this.installInput(this.inputsMapBinder(), messageInputClass, factoryClass);
    }

    protected void addMessageFilter(Class<? extends MessageFilter> messageFilterClass) {
        Multibinder messageInputs = Multibinder.newSetBinder((Binder)this.binder(), MessageFilter.class);
        messageInputs.addBinding().to(messageFilterClass);
    }

    protected void addPeriodical(Class<? extends Periodical> periodicalClass) {
        Multibinder periodicalBinder = Multibinder.newSetBinder((Binder)this.binder(), Periodical.class);
        periodicalBinder.addBinding().to(periodicalClass);
    }

    protected void addRotationStrategy(Class<? extends RotationStrategy> rotationStrategyClass) {
        this.installRotationStrategy(this.rotationStrategiesMapBinder(), rotationStrategyClass);
    }

    protected void addRetentionStrategy(Class<? extends RetentionStrategy> retentionStrategyClass) {
        this.installRetentionStrategy(this.retentionStrategyMapBinder(), retentionStrategyClass);
    }

    protected void addAlarmCallback(Class<? extends AlarmCallback> alarmCallbackClass) {
        Multibinder alarmCallbackInstanceBinder = Multibinder.newSetBinder((Binder)this.binder(), AlarmCallback.class);
        alarmCallbackInstanceBinder.addBinding().to(alarmCallbackClass);
        TypeLiteral<Class<? extends AlarmCallback>> type = new TypeLiteral<Class<? extends AlarmCallback>>(){};
        Multibinder alarmCallbackBinder = Multibinder.newSetBinder((Binder)this.binder(), (TypeLiteral)type);
        alarmCallbackBinder.addBinding().toInstance(alarmCallbackClass);
    }

    protected void addInitializer(Class<? extends Service> initializerClass) {
        Multibinder<Service> serviceBinder = this.serviceBinder();
        serviceBinder.addBinding().to(initializerClass);
    }

    protected void addMessageOutput(Class<? extends MessageOutput> messageOutputClass) {
        this.installOutput(this.outputsMapBinder(), messageOutputClass);
    }

    protected <T extends MessageOutput> void addMessageOutput(Class<T> messageOutputClass, Class<? extends MessageOutput.Factory<T>> factory) {
        this.installOutput(this.outputsMapBinder(), messageOutputClass, factory);
    }

    protected void addRestResource(Class<? extends PluginRestResource> restResourceClass) {
        MapBinder pluginRestResourceMapBinder = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<String>(){}, (TypeLiteral)new TypeLiteral<Class<? extends PluginRestResource>>(){}).permitDuplicates();
        pluginRestResourceMapBinder.addBinding((Object)((Object)((Object)this)).getClass().getPackage().getName()).toInstance(restResourceClass);
    }

    protected void addConfigBeans() {
        Multibinder pluginConfigBeans = Multibinder.newSetBinder((Binder)this.binder(), PluginConfigBean.class);
        for (PluginConfigBean pluginConfigBean : this.getConfigBeans()) {
            pluginConfigBeans.addBinding().toInstance((Object)pluginConfigBean);
        }
    }

    protected void addTransport(String name, Class<? extends Transport> transportClass) {
        this.installTransport(this.transportMapBinder(), name, transportClass);
    }

    protected void addTransport(String name, Class<? extends Transport> transportClass, Class<? extends Transport.Config> configClass, Class<? extends Transport.Factory<? extends Transport>> factoryClass) {
        this.installTransport(this.transportMapBinder(), name, transportClass, configClass, factoryClass);
    }

    protected void addCodec(String name, Class<? extends Codec> codecClass) {
        this.installCodec(this.codecMapBinder(), name, codecClass);
    }

    protected void addCodec(String name, Class<? extends Codec> codecClass, Class<? extends Codec.Config> configClass, Class<? extends Codec.Factory<? extends Codec>> factoryClass) {
        this.installCodec(this.codecMapBinder(), name, codecClass, configClass, factoryClass);
    }

    protected void addPasswordAlgorithm(String passwordAlgorithmName, Class<? extends PasswordAlgorithm> passwordAlgorithmClass) {
        this.passwordAlgorithmBinder().addBinding((Object)passwordAlgorithmName).to(passwordAlgorithmClass);
    }

    protected Multibinder<MessageProcessor> processorBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), MessageProcessor.class);
    }

    protected Multibinder<MessageProcessor.Descriptor> processorDescriptorBinder() {
        return Multibinder.newSetBinder((Binder)this.binder(), MessageProcessor.Descriptor.class);
    }

    protected void addMessageProcessor(Class<? extends MessageProcessor> processorClass, Class<? extends MessageProcessor.Descriptor> descriptorClass) {
        this.processorBinder().addBinding().to(processorClass);
        this.processorDescriptorBinder().addBinding().to(descriptorClass);
    }

    protected <T extends WidgetStrategy> void addWidgetStrategy(Class<T> widgetStrategyClass, Class<? extends WidgetStrategy.Factory<T>> factory) {
        this.installWidgetStrategy(this.widgetStrategyBinder(), widgetStrategyClass, factory);
    }

    protected void addPermissions(Class<? extends PluginPermissions> permissionsClass) {
        this.installPermissions(this.permissionsBinder(), permissionsClass);
    }

    protected void addAuditLogAppender(Class<? extends AuditLogAppender> auditLogAppenderClass) {
        Multibinder appenders = Multibinder.newSetBinder((Binder)this.binder(), AuditLogAppender.class);
        appenders.addBinding().to(auditLogAppenderClass);
    }
}

