/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.MediaType;
import javax.inject.Inject;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.graylog2.cluster.Node;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class RemoteInterfaceProvider {
    private final ObjectMapper objectMapper;
    private final OkHttpClient okHttpClient;

    @Inject
    public RemoteInterfaceProvider(ObjectMapper objectMapper, OkHttpClient okHttpClient) {
        this.objectMapper = objectMapper;
        this.okHttpClient = okHttpClient;
    }

    public <T> T get(Node node, String authorizationToken, Class<T> interfaceClass) {
        OkHttpClient okHttpClient = this.okHttpClient.newBuilder().addInterceptor(chain -> {
            Request original = chain.request();
            Request.Builder builder = original.newBuilder().header("Accept", MediaType.JSON_UTF_8.toString()).method(original.method(), original.body());
            if (authorizationToken != null) {
                builder = builder.header("Authorization", authorizationToken);
            }
            return chain.proceed(builder.build());
        }).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(node.getTransportAddress()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)this.objectMapper)).client(okHttpClient).build();
        return (T)retrofit.create(interfaceClass);
    }

    public <T> T get(Node node, Class<T> interfaceClass) {
        return this.get(node, null, interfaceClass);
    }
}

