/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.auditlog.jersey.AuditLog;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.resources.system.RemoteSystemShutdownResource;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

@RequiresAuthentication
@Api(value="Cluster/Shutdown", description="Shutdown gracefully nodes in cluster")
@Path(value="/cluster/{nodeId}/shutdown")
@Produces(value={"application/json"})
public class ClusterSystemShutdownResource
extends ProxiedResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterSystemShutdownResource.class);

    @Inject
    public ClusterSystemShutdownResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders) throws NodeNotFoundException {
        super(httpHeaders, nodeService, remoteInterfaceProvider);
    }

    @POST
    @Timed
    @ApiOperation(value="Shutdown node gracefully.", notes="Attempts to process all buffered and cached messages before exiting, shuts down inputs first to make sure that no new messages are accepted.")
    @AuditLog(action="shutdown", object="Graylog node")
    public void shutdown(@ApiParam(name="nodeId", value="The id of the node to shutdown.", required=true) @PathParam(value="nodeId") String nodeId) throws IOException, NodeNotFoundException {
        Node targetNode = this.nodeService.byNodeId(nodeId);
        RemoteSystemShutdownResource remoteSystemShutdownResource = this.remoteInterfaceProvider.get(targetNode, this.authenticationToken, RemoteSystemShutdownResource.class);
        Response response = remoteSystemShutdownResource.shutdown().execute();
        if (response.code() != HttpResponseStatus.ACCEPTED.getCode()) {
            LOG.warn("Unable send shut down signal to node {}: {}", (Object)nodeId, (Object)response.message());
            throw new WebApplicationException(response.message(), Response.Status.BAD_GATEWAY);
        }
    }
}

