/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.streams.alerts;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.DELETE;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.mail.EmailException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.elasticsearch.common.Strings;
import org.graylog2.alarmcallbacks.AlarmCallbackConfiguration;
import org.graylog2.alarmcallbacks.AlarmCallbackConfigurationService;
import org.graylog2.alarmcallbacks.AlarmCallbackFactory;
import org.graylog2.alarmcallbacks.EmailAlarmCallback;
import org.graylog2.alerts.AbstractAlertCondition;
import org.graylog2.alerts.types.DummyAlertCondition;
import org.graylog2.auditlog.jersey.AuditLog;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.alarms.callbacks.AlarmCallback;
import org.graylog2.plugin.alarms.callbacks.AlarmCallbackConfigurationException;
import org.graylog2.plugin.alarms.callbacks.AlarmCallbackException;
import org.graylog2.plugin.alarms.transports.TransportConfigurationException;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.rest.resources.streams.alerts.StreamAlertResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="AlertReceivers", description="Manage stream alert receivers")
@Path(value="/streams/{streamId}/alerts")
public class StreamAlertReceiverResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(StreamAlertReceiverResource.class);
    private final StreamService streamService;
    private final AlarmCallbackConfigurationService alarmCallbackConfigurationService;
    private final EmailAlarmCallback emailAlarmCallback;
    private final AlarmCallbackFactory alarmCallbackFactory;

    @Inject
    public StreamAlertReceiverResource(StreamService streamService, AlarmCallbackConfigurationService alarmCallbackConfigurationService, EmailAlarmCallback emailAlarmCallback, AlarmCallbackFactory alarmCallbackFactory) {
        this.streamService = streamService;
        this.alarmCallbackConfigurationService = alarmCallbackConfigurationService;
        this.emailAlarmCallback = emailAlarmCallback;
        this.alarmCallbackFactory = alarmCallbackFactory;
    }

    @POST
    @Timed
    @Path(value="receivers")
    @ApiOperation(value="Add an alert receiver")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditLog(object="alert receiver")
    public Response addReceiver(@ApiParam(name="streamId", value="The stream id this new alert condition belongs to.", required=true) @PathParam(value="streamId") String streamid, @ApiParam(name="entity", value="Name/ID of user or email address to add as alert receiver.", required=true) @QueryParam(value="entity") String entity, @ApiParam(name="type", value="Type: users or emails", required=true) @QueryParam(value="type") String type) throws NotFoundException {
        this.checkPermission("streams:edit", streamid);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)entity) ? 1 : 0) != 0);
        if (type == null || !type.equals("users") && !type.equals("emails")) {
            String msg = "No such type: [" + type + "]";
            LOG.warn(msg);
            throw new BadRequestException(msg);
        }
        Stream stream = this.streamService.load(streamid);
        URI streamAlertUri = this.getUriBuilderToSelf().path(StreamAlertResource.class).build(new Object[]{streamid});
        if ((stream.getAlertReceivers().containsKey(type) || stream.getAlertReceivers().get(type) != null) && stream.getAlertReceivers().get(type).contains(entity)) {
            return Response.created((URI)streamAlertUri).build();
        }
        this.streamService.addAlertReceiver(stream, type, entity);
        return Response.created((URI)streamAlertUri).build();
    }

    @DELETE
    @Timed
    @Path(value="receivers")
    @ApiOperation(value="Remove an alert receiver")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    @AuditLog(object="alert receiver")
    public void removeReceiver(@ApiParam(name="streamId", value="The stream id this new alert condition belongs to.", required=true) @PathParam(value="streamId") String streamid, @ApiParam(name="entity", value="Name/ID of user or email address to remove from alert receivers.", required=true) @QueryParam(value="entity") String entity, @ApiParam(name="type", value="Type: users or emails", required=true) @QueryParam(value="type") String type) throws NotFoundException {
        this.checkPermission("streams:edit", streamid);
        if (!"users".equals(type) && !"emails".equals(type)) {
            String msg = "No such type: [" + type + "]";
            LOG.warn(msg);
            throw new BadRequestException(msg);
        }
        Stream stream = this.streamService.load(streamid);
        this.streamService.removeAlertReceiver(stream, type, entity);
    }

    @POST
    @Timed
    @Path(value="sendDummyAlert")
    @ApiOperation(value="Send a test mail for a given stream")
    @ApiResponses(value={@ApiResponse(code=404, message="Stream not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public Response sendDummyAlert(@ApiParam(name="streamId", value="The stream id the dummy alert should be sent for.", required=true) @PathParam(value="streamId") String streamid) throws TransportConfigurationException, EmailException, NotFoundException {
        this.checkPermission("streams:edit", streamid);
        Stream stream = this.streamService.load(streamid);
        DummyAlertCondition dummyAlertCondition = new DummyAlertCondition(stream, null, Tools.nowUTC(), this.getSubject().getPrincipal().toString(), Collections.emptyMap(), "Dummy Alert");
        try {
            AbstractAlertCondition.CheckResult checkResult = dummyAlertCondition.runCheck();
            List<AlarmCallbackConfiguration> callConfigurations = this.alarmCallbackConfigurationService.getForStream(stream);
            if (callConfigurations.size() > 0) {
                for (AlarmCallbackConfiguration configuration : callConfigurations) {
                    AlarmCallback alarmCallback = this.alarmCallbackFactory.create(configuration);
                    alarmCallback.call(stream, checkResult);
                }
            } else {
                this.emailAlarmCallback.call(stream, checkResult);
            }
        }
        catch (ClassNotFoundException | AlarmCallbackConfigurationException | AlarmCallbackException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
        return Response.noContent().build();
    }
}

