/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.inject.Inject;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.auditlog.jersey.AuditLog;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.system.shutdown.GracefulShutdown;

@RequiresAuthentication
@Api(value="System/Shutdown", description="Shutdown this node gracefully.")
@Path(value="/system/shutdown")
public class SystemShutdownResource
extends RestResource {
    private final GracefulShutdown gracefulShutdown;
    private final ServerStatus serverStatus;

    @Inject
    public SystemShutdownResource(GracefulShutdown gracefulShutdown, ServerStatus serverStatus) {
        this.gracefulShutdown = gracefulShutdown;
        this.serverStatus = serverStatus;
    }

    @POST
    @Timed
    @ApiOperation(value="Shutdown this node gracefully.", notes="Attempts to process all buffered and cached messages before exiting, shuts down inputs first to make sure that no new messages are accepted.")
    @Path(value="/shutdown")
    @AuditLog(action="shutdown", object="Graylog node")
    public Response shutdown() {
        this.checkPermission("node:shutdown", this.serverStatus.getNodeId().toString());
        new Thread(this.gracefulShutdown).start();
        return Response.accepted().build();
    }
}

