/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.ConfigurationException;
import org.graylog2.inputs.extractors.JsonExtractor;
import org.graylog2.plugin.inputs.Extractor;
import org.graylog2.rest.models.tools.requests.JsonTestRequest;
import org.graylog2.rest.models.tools.responses.JsonTesterResponse;
import org.graylog2.shared.rest.resources.RestResource;
import org.hibernate.validator.constraints.NotEmpty;

@RequiresAuthentication
@Path(value="/tools/json_tester")
@Produces(value={"application/json"})
public class JsonTesterResource
extends RestResource {
    @GET
    @Timed
    public JsonTesterResponse get(@QueryParam(value="string") @NotEmpty String string, @QueryParam(value="flatten") @DefaultValue(value="false") boolean flatten, @QueryParam(value="list_separator") @NotEmpty String listSeparator, @QueryParam(value="key_separator") @NotEmpty String keySeparator, @QueryParam(value="replace_key_whitespace") boolean replaceKeyWhitespace, @QueryParam(value="key_whitespace_replacement") String keyWhitespaceReplacement, @QueryParam(value="key_prefix") String keyPrefix, @QueryParam(value="kv_separator") @NotEmpty String kvSeparator) {
        return this.testJsonExtractor(string, flatten, listSeparator, keySeparator, kvSeparator, replaceKeyWhitespace, keyWhitespaceReplacement, keyPrefix);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    public JsonTesterResponse post(@Valid @NotNull JsonTestRequest r) {
        return this.testJsonExtractor(r.string(), r.flatten(), r.listSeparator(), r.keySeparator(), r.kvSeparator(), r.replaceKeyWhitespace(), r.keyWhitespaceReplacement(), r.keyPrefix());
    }

    private JsonTesterResponse testJsonExtractor(String testString, boolean flatten, String listSeparator, String keySeparator, String kvSeparator, boolean replaceKeyWhitespace, String keyWhitespaceReplacement, String keyPrefix) {
        JsonExtractor extractor;
        ImmutableMap config = ImmutableMap.builder().put((Object)"flatten", (Object)flatten).put((Object)"list_separator", (Object)listSeparator).put((Object)"key_separator", (Object)keySeparator).put((Object)"kv_separator", (Object)kvSeparator).put((Object)"replace_key_whitespace", (Object)replaceKeyWhitespace).put((Object)"key_whitespace_replacement", (Object)keyWhitespaceReplacement).put((Object)"key_prefix", (Object)keyPrefix).build();
        try {
            extractor = new JsonExtractor(new MetricRegistry(), "test", "Test", 0L, Extractor.CursorStrategy.COPY, "test", "test", (Map<String, Object>)config, this.getCurrentUser().getName(), Collections.emptyList(), Extractor.ConditionType.NONE, "");
        }
        catch (Extractor.ReservedFieldException e) {
            throw new BadRequestException("Trying to overwrite a reserved message field", (Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new BadRequestException("Invalid extractor configuration", (Throwable)e);
        }
        Map<String, Object> result = extractor.extractJson(testString);
        return JsonTesterResponse.create(result, flatten, listSeparator, keySeparator, kvSeparator, testString);
    }
}

