/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import java.io.Serializable;
import javax.inject.Inject;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.realm.LdapUserAuthenticator;
import org.graylog2.shared.security.SessionIdToken;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionAuthenticator
extends AuthenticatingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(SessionAuthenticator.class);
    public static final String NAME = "mongodb-session";
    private final UserService userService;
    private final LdapUserAuthenticator ldapAuthenticator;

    @Inject
    SessionAuthenticator(UserService userService, LdapUserAuthenticator ldapAuthenticator) {
        this.userService = userService;
        this.ldapAuthenticator = ldapAuthenticator;
        this.setCredentialsMatcher((CredentialsMatcher)new AllowAllCredentialsMatcher());
        this.setAuthenticationTokenClass(SessionIdToken.class);
        this.setCachingEnabled(false);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        MultivaluedMap requestHeaders;
        SessionIdToken sessionIdToken = (SessionIdToken)token;
        Subject subject = new Subject.Builder().sessionId((Serializable)((Object)sessionIdToken.getSessionId())).buildSubject();
        Session session = subject.getSession(false);
        if (session == null) {
            LOG.debug("Invalid session {}. Either it has expired or did not exist.", (Object)sessionIdToken.getSessionId());
            return null;
        }
        Object username = subject.getPrincipal();
        User user = this.userService.load(String.valueOf(username));
        if (user == null) {
            LOG.debug("No user named {} found for session {}", username, (Object)sessionIdToken.getSessionId());
            return null;
        }
        if (user.isExternalUser() && !this.ldapAuthenticator.isEnabled()) {
            throw new LockedAccountException("LDAP authentication is currently disabled.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found session {} for user name {}", (Object)session.getId(), username);
        }
        if ((requestHeaders = (MultivaluedMap)ThreadContext.get((Object)"REQUEST_HEADERS")) == null || !"true".equalsIgnoreCase((String)requestHeaders.getFirst((Object)"X-Graylog-No-Session-Extension"))) {
            session.touch();
        } else {
            LOG.debug("Not extending session because the request indicated not to.");
        }
        ThreadContext.bind((Subject)subject);
        return new SimpleAccount((Object)user.getName(), null, "session authenticator");
    }
}

