/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.bindings;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;

public class Hk2GuiceBridgeJitInjector
implements InvocationHandler {
    private static Method getExistingBindingMethod;
    private static Method getBindingMethod;
    private static Method getTypeLiteralMethod;
    private static Method getRawTypeMethod;
    private final Set<String> packagePrefixes;
    private final Injector injector;

    public static Injector create(Module module, String ... packagePrefixes) {
        return Hk2GuiceBridgeJitInjector.create(Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{module}), packagePrefixes);
    }

    public static Injector create(Iterable<? extends Module> modules, String ... packagePrefixes) {
        return Hk2GuiceBridgeJitInjector.create(Guice.createInjector((Stage)Stage.PRODUCTION, modules), packagePrefixes);
    }

    public static Injector create(Injector injector, String ... packagePrefixes) {
        return (Injector)Proxy.newProxyInstance(Injector.class.getClassLoader(), new Class[]{Injector.class}, (InvocationHandler)new Hk2GuiceBridgeJitInjector(injector, packagePrefixes));
    }

    private Hk2GuiceBridgeJitInjector(Injector injector, String ... packagePrefixes) {
        this.packagePrefixes = Sets.newHashSet((Object[])packagePrefixes);
        this.injector = (Injector)Preconditions.checkNotNull((Object)injector);
    }

    private boolean isInsideTargettedPackage(Class<?> type) {
        String packageName = type.getPackage().getName();
        for (String packagePrefix : this.packagePrefixes) {
            if (!packageName.startsWith(packagePrefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = method.invoke((Object)this.injector, args);
        if (result == null && method.equals(getExistingBindingMethod) && this.isInsideTargettedPackage((Class)getRawTypeMethod.invoke(getTypeLiteralMethod.invoke(args[0], new Object[0]), new Object[0]))) {
            return getBindingMethod.invoke((Object)this.injector, args[0]);
        }
        return result;
    }

    static {
        try {
            getExistingBindingMethod = Injector.class.getDeclaredMethod("getExistingBinding", Key.class);
            getBindingMethod = Injector.class.getDeclaredMethod("getBinding", Key.class);
            getTypeLiteralMethod = Key.class.getDeclaredMethod("getTypeLiteral", new Class[0]);
            getRawTypeMethod = TypeLiteral.class.getDeclaredMethod("getRawType", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

