/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.initializers;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ResourceFinder;
import org.glassfish.jersey.server.filter.EncodingFilter;
import org.glassfish.jersey.server.internal.scanning.PackageNamesScanner;
import org.glassfish.jersey.server.model.Resource;
import org.graylog2.shared.initializers.RestApiService;
import org.graylog2.shared.rest.CORSFilter;
import org.graylog2.shared.rest.NodeIdResponseFilter;
import org.graylog2.shared.rest.NotAuthorizedResponseFilter;
import org.graylog2.shared.rest.PrintModelProcessor;
import org.graylog2.shared.rest.RestAccessLogFilter;
import org.graylog2.shared.rest.XHRFilter;
import org.graylog2.shared.rest.exceptionmappers.AnyExceptionClassMapper;
import org.graylog2.shared.rest.exceptionmappers.BadRequestExceptionMapper;
import org.graylog2.shared.rest.exceptionmappers.JacksonPropertyExceptionMapper;
import org.graylog2.shared.rest.exceptionmappers.JsonProcessingExceptionMapper;
import org.graylog2.shared.rest.exceptionmappers.WebApplicationExceptionMapper;
import org.graylog2.shared.security.tls.KeyStoreUtils;
import org.graylog2.shared.security.tls.PemKeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJerseyService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJerseyService.class);
    private final Set<Class<? extends DynamicFeature>> dynamicFeatures;
    private final Set<Class<? extends ContainerResponseFilter>> containerResponseFilters;
    private final Set<Class<? extends ExceptionMapper>> exceptionMappers;
    private final Set<Class> additionalComponents;
    private final ObjectMapper objectMapper;
    private final MetricRegistry metricRegistry;
    protected HttpServer httpServer = null;

    public AbstractJerseyService(Set<Class<? extends DynamicFeature>> dynamicFeatures, Set<Class<? extends ContainerResponseFilter>> containerResponseFilters, Set<Class<? extends ExceptionMapper>> exceptionMappers, Set<Class> additionalComponents, ObjectMapper objectMapper, MetricRegistry metricRegistry) {
        this.dynamicFeatures = dynamicFeatures;
        this.containerResponseFilters = containerResponseFilters;
        this.exceptionMappers = exceptionMappers;
        this.additionalComponents = additionalComponents;
        this.objectMapper = objectMapper;
        this.metricRegistry = metricRegistry;
    }

    protected ResourceConfig buildResourceConfig(boolean enableGzip, boolean enableCors, Set<Resource> additionalResources, String[] controllerPackages) {
        ResourceConfig rc = new ResourceConfig().property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", (Object)true).property("jersey.config.server.wadl.disableWadl", (Object)true).registerClasses(new Class[]{JacksonJaxbJsonProvider.class, JsonProcessingExceptionMapper.class, JacksonPropertyExceptionMapper.class, AnyExceptionClassMapper.class, WebApplicationExceptionMapper.class, BadRequestExceptionMapper.class}).register((Object)new ContextResolver<ObjectMapper>(){

            public ObjectMapper getContext(Class<?> type) {
                return AbstractJerseyService.this.objectMapper;
            }
        }).registerFinder((ResourceFinder)new PackageNamesScanner(controllerPackages, true)).registerResources(additionalResources).register(RestAccessLogFilter.class).register(NodeIdResponseFilter.class).register(XHRFilter.class).register(NotAuthorizedResponseFilter.class);
        this.exceptionMappers.forEach(xva$0 -> rc.registerClasses(new Class[]{xva$0}));
        this.dynamicFeatures.forEach(xva$0 -> rc.registerClasses(new Class[]{xva$0}));
        this.containerResponseFilters.forEach(xva$0 -> rc.registerClasses(new Class[]{xva$0}));
        this.additionalComponents.forEach(xva$0 -> rc.registerClasses(new Class[]{xva$0}));
        if (enableGzip) {
            EncodingFilter.enableFor((ResourceConfig)rc, (Class[])new Class[]{GZipEncoder.class});
        }
        if (enableCors) {
            LOG.info("Enabling CORS for HTTP endpoint");
            rc.register(CORSFilter.class);
        }
        if (LOG.isDebugEnabled()) {
            rc.register(PrintModelProcessor.class);
        }
        return rc;
    }

    protected HttpServer setUp(String namePrefix, URI listenUri, boolean enableTls, Path tlsCertFile, Path tlsKeyFile, String tlsKeyPassword, int threadPoolSize, int maxInitialLineLength, int maxHeaderSize, boolean enableGzip, boolean enableCors, Set<Resource> additionalResources, String[] controllerPackages) throws GeneralSecurityException, IOException {
        ResourceConfig resourceConfig = this.buildResourceConfig(enableGzip, enableCors, additionalResources, controllerPackages);
        SSLEngineConfigurator sslEngineConfigurator = enableTls ? this.buildSslEngineConfigurator(tlsCertFile, tlsKeyFile, tlsKeyPassword) : null;
        this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)listenUri, (ResourceConfig)resourceConfig, (boolean)enableTls, (SSLEngineConfigurator)sslEngineConfigurator);
        NetworkListener listener = this.httpServer.getListener("grizzly");
        listener.setMaxHttpHeaderSize(maxInitialLineLength);
        listener.setMaxRequestHeaders(maxHeaderSize);
        ExecutorService workerThreadPoolExecutor = this.instrumentedExecutor(namePrefix + "-worker-executor", namePrefix + "-worker-%d", threadPoolSize);
        listener.getTransport().setWorkerThreadPool(workerThreadPoolExecutor);
        return this.httpServer;
    }

    protected SSLEngineConfigurator buildSslEngineConfigurator(Path certFile, Path keyFile, String keyPassword) throws GeneralSecurityException, IOException {
        if (keyFile == null || !Files.isRegularFile(keyFile, new LinkOption[0]) || !Files.isReadable(keyFile)) {
            throw new InvalidKeyException("Unreadable or missing private key: " + keyFile);
        }
        if (certFile == null || !Files.isRegularFile(certFile, new LinkOption[0]) || !Files.isReadable(certFile)) {
            throw new CertificateException("Unreadable or missing X.509 certificate: " + certFile);
        }
        SSLContextConfigurator sslContext = new SSLContextConfigurator();
        char[] password = ((String)MoreObjects.firstNonNull((Object)keyPassword, (Object)"")).toCharArray();
        KeyStore keyStore = PemKeyStore.buildKeyStore(certFile, keyFile, password);
        sslContext.setKeyStorePass(password);
        sslContext.setKeyStoreBytes(KeyStoreUtils.getBytes(keyStore, password));
        if (!sslContext.validateConfiguration(true)) {
            throw new IllegalStateException("Couldn't initialize SSL context for HTTP server");
        }
        return new SSLEngineConfigurator(sslContext.createSSLContext(), false, false, false);
    }

    protected ExecutorService instrumentedExecutor(String executorName, String threadNameFormat, int poolSize) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(threadNameFormat).setDaemon(true).build();
        return new InstrumentedExecutorService(Executors.newFixedThreadPool(poolSize, threadFactory), this.metricRegistry, MetricRegistry.name(RestApiService.class, (String[])new String[]{executorName}));
    }
}

