/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.initializers;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.jersey.server.model.Resource;
import org.graylog2.plugin.BaseConfiguration;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.initializers.AbstractJerseyService;
import org.graylog2.web.resources.AppConfigResource;
import org.graylog2.web.resources.WebInterfaceAssetsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RestApiService
extends AbstractJerseyService {
    private static final Logger LOG = LoggerFactory.getLogger(RestApiService.class);
    public static final String PLUGIN_PREFIX = "/plugins";
    private final BaseConfiguration configuration;
    private final Map<String, Set<Class<? extends PluginRestResource>>> pluginRestResources;
    private final String[] restControllerPackages;
    private final WebInterfaceAssetsResource webInterfaceAssetsResource;
    private final AppConfigResource appConfigResource;

    @Inject
    private RestApiService(BaseConfiguration configuration, MetricRegistry metricRegistry, Set<Class<? extends DynamicFeature>> dynamicFeatures, Set<Class<? extends ContainerResponseFilter>> containerResponseFilters, Set<Class<? extends ExceptionMapper>> exceptionMappers, @Named(value="additionalJerseyComponents") Set<Class> additionalComponents, Map<String, Set<Class<? extends PluginRestResource>>> pluginRestResources, @Named(value="RestControllerPackages") String[] restControllerPackages, ObjectMapper objectMapper, WebInterfaceAssetsResource webInterfaceAssetsResource, AppConfigResource appConfigResource) {
        super(dynamicFeatures, containerResponseFilters, exceptionMappers, additionalComponents, objectMapper, metricRegistry);
        this.configuration = configuration;
        this.pluginRestResources = pluginRestResources;
        this.restControllerPackages = restControllerPackages;
        this.webInterfaceAssetsResource = webInterfaceAssetsResource;
        this.appConfigResource = appConfigResource;
    }

    protected void startUp() throws Exception {
        ImmutableSet.Builder additionalResourcesBuilder = ImmutableSet.builder().addAll(this.prefixPluginResources(PLUGIN_PREFIX, this.pluginRestResources));
        if (this.configuration.isWebEnable() && this.configuration.isRestAndWebOnSamePort()) {
            additionalResourcesBuilder = additionalResourcesBuilder.addAll(this.prefixResources(this.configuration.getWebPrefix(), (Set)ImmutableSet.of(this.webInterfaceAssetsResource.getClass(), this.appConfigResource.getClass())));
        }
        this.httpServer = this.setUp("rest", this.configuration.getRestListenUri(), this.configuration.isRestEnableTls(), this.configuration.getRestTlsCertFile(), this.configuration.getRestTlsKeyFile(), this.configuration.getRestTlsKeyPassword(), this.configuration.getRestThreadPoolSize(), this.configuration.getRestMaxInitialLineLength(), this.configuration.getRestMaxHeaderSize(), this.configuration.isRestEnableGzip(), this.configuration.isRestEnableCors(), (Set<Resource>)additionalResourcesBuilder.build(), this.restControllerPackages);
        this.httpServer.start();
        LOG.info("Started REST API at <{}>", (Object)this.configuration.getRestListenUri());
        if (this.configuration.isWebEnable() && this.configuration.isRestAndWebOnSamePort()) {
            LOG.info("Started Web Interface at <{}>", (Object)this.configuration.getWebListenUri());
        }
    }

    private Set<Resource> prefixPluginResources(String pluginPrefix, Map<String, Set<Class<? extends PluginRestResource>>> pluginResourceMap) {
        return pluginResourceMap.entrySet().stream().map(entry -> this.prefixResources(pluginPrefix + "/" + (String)entry.getKey(), (Set)entry.getValue())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private <T> Set<Resource> prefixResources(String prefix, Set<Class<? extends T>> resources) {
        String pathPrefix = prefix.endsWith("/") ? prefix.substring(0, prefix.length() - 1) : prefix;
        return resources.stream().map(resource -> {
            Path pathAnnotation = Resource.getPath((Class)resource);
            String resourcePathSuffix = Strings.nullToEmpty((String)pathAnnotation.value());
            String resourcePath = resourcePathSuffix.startsWith("/") ? pathPrefix + resourcePathSuffix : pathPrefix + "/" + resourcePathSuffix;
            return Resource.builder((Class)resource).path(resourcePath).build();
        }).collect(Collectors.toSet());
    }

    protected void shutDown() throws Exception {
        if (this.httpServer != null && this.httpServer.isStarted()) {
            LOG.info("Shutting down REST API at <{}>", (Object)this.configuration.getRestListenUri());
            this.httpServer.shutdownNow();
        }
    }
}

