/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.server.model.ModelProcessor;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.server.model.ResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintModelProcessor
implements ModelProcessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)"REST API");

    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        LOG.debug("Map for resource model <" + resourceModel + ">:");
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Resource resource : resourceModel.getResources()) {
            resources.add(resource);
            resources.addAll(this.findChildResources(resource));
        }
        this.logResources(resources);
        return resourceModel;
    }

    public ResourceModel processSubResource(ResourceModel subResourceModel, Configuration configuration) {
        LOG.debug("Map for sub-resource model <" + subResourceModel + ">:");
        this.logResources(subResourceModel.getResources());
        return subResourceModel;
    }

    private void logResources(List<Resource> resources) {
        ArrayList<ResourceDescription> resourceDescriptions = new ArrayList<ResourceDescription>();
        for (Resource resource : resources) {
            for (ResourceMethod resourceMethod : resource.getAllMethods()) {
                String path = resource.getPath();
                for (Resource parent = resource.getParent(); parent != null; parent = parent.getParent()) {
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    path = parent.getPath() + path;
                }
                resourceDescriptions.add(new ResourceDescription(resourceMethod.getHttpMethod(), path, resource.getHandlerClasses()));
            }
        }
        Collections.sort(resourceDescriptions);
        for (ResourceDescription resourceDescription : resourceDescriptions) {
            LOG.debug(resourceDescription.toString());
        }
    }

    private List<Resource> findChildResources(Resource parentResource) {
        ArrayList<Resource> childResources = new ArrayList<Resource>();
        for (Resource resource : parentResource.getChildResources()) {
            childResources.add(resource);
            childResources.addAll(this.findChildResources(resource));
        }
        return childResources;
    }

    private static class ResourceDescription
    implements Comparable<ResourceDescription> {
        private String method;
        private String path;
        private Set<Class<?>> handlerClasses;

        private ResourceDescription(String method, String path, Set<Class<?>> handlerClasses) {
            this.method = method;
            this.path = path;
            this.handlerClasses = handlerClasses;
        }

        @Override
        public int compareTo(ResourceDescription o) {
            if (this.path.compareTo(o.path) == 0) {
                return this.method.compareTo(o.method);
            }
            return this.path.compareTo(o.path);
        }

        public String toString() {
            return String.format(Locale.ENGLISH, "    %-7s %s (%s)", this.method, this.path, Joiner.on((String)", ").join(this.handlerClasses));
        }
    }
}

