/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.documentation;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import javax.activation.MimetypesFileTypeMap;
import javax.inject.Inject;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.graylog2.shared.rest.resources.RestResource;

@Path(value="/api-browser")
public class DocumentationBrowserResource
extends RestResource {
    private final MimetypesFileTypeMap mimeTypes;
    private ClassLoader classLoader = ClassLoader.getSystemClassLoader();

    @Inject
    public DocumentationBrowserResource(MimetypesFileTypeMap mimeTypes) {
        this.mimeTypes = Objects.requireNonNull(mimeTypes);
    }

    @GET
    public Response root() {
        return this.asset("index.html");
    }

    @GET
    @Path(value="/{route: .*}")
    public Response asset(@PathParam(value="route") String route) {
        URL resource;
        if (route.contains("..")) {
            throw new BadRequestException("Not allowed to access parent directory");
        }
        if (route.trim().equals("")) {
            route = "index.html";
        }
        if (null != (resource = this.classLoader.getResource("swagger/" + route))) {
            try {
                byte[] resourceBytes = Resources.toByteArray((URL)resource);
                return Response.ok((Object)resourceBytes, (String)this.mimeTypes.getContentType(route)).header("Content-Length", (Object)resourceBytes.length).build();
            }
            catch (IOException e) {
                throw new NotFoundException("Couldn't load " + resource, (Throwable)e);
            }
        }
        throw new NotFoundException("Couldn't find " + route);
    }
}

