/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.system;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.rest.models.system.metrics.requests.MetricsReadRequest;
import org.graylog2.rest.models.system.metrics.responses.MetricNamesResponse;
import org.graylog2.rest.models.system.metrics.responses.MetricsSummaryResponse;
import org.graylog2.shared.metrics.MetricUtils;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresAuthentication
@Api(value="System/Metrics", description="Internal Graylog metrics")
@Path(value="/system/metrics")
public class MetricsResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsResource.class);
    private final MetricRegistry metricRegistry;

    @Inject
    public MetricsResource(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    @GET
    @Timed
    @RequiresPermissions(value={"metrics:readall"})
    @ApiOperation(value="Get all metrics", notes="Note that this might return a huge result set.")
    @Produces(value={"application/json"})
    public MetricRegistry metrics() {
        return this.metricRegistry;
    }

    @GET
    @Timed
    @Path(value="/names")
    @ApiOperation(value="Get all metrics keys/names")
    @RequiresPermissions(value={"metrics:allkeys"})
    @Produces(value={"application/json"})
    public MetricNamesResponse metricNames() {
        return MetricNamesResponse.create(this.metricRegistry.getNames());
    }

    @GET
    @Timed
    @Path(value="/{metricName}")
    @ApiOperation(value="Get a single metric")
    @ApiResponses(value={@ApiResponse(code=404, message="No such metric")})
    @Produces(value={"application/json"})
    public Metric singleMetric(@ApiParam(name="metricName", required=true) @PathParam(value="metricName") String metricName) {
        this.checkPermission("metrics:read", metricName);
        Metric metric = (Metric)this.metricRegistry.getMetrics().get(metricName);
        if (metric == null) {
            String msg = "I do not have a metric called [" + metricName + "].";
            LOG.debug(msg);
            throw new NotFoundException(msg);
        }
        return metric;
    }

    @POST
    @Timed
    @Path(value="/multiple")
    @ApiOperation(value="Get the values of multiple metrics at once")
    @ApiResponses(value={@ApiResponse(code=400, message="Malformed body")})
    public MetricsSummaryResponse multipleMetrics(@ApiParam(name="Requested metrics", required=true) @Valid @NotNull MetricsReadRequest request) {
        Map metrics = this.metricRegistry.getMetrics();
        ArrayList metricsList = Lists.newArrayList();
        for (String name : request.metrics()) {
            Metric metric;
            if (!this.isPermitted("metrics:read", name) || (metric = (Metric)metrics.get(name)) == null) continue;
            metricsList.add(MetricUtils.map(name, metric));
        }
        return MetricsSummaryResponse.create(metricsList);
    }

    @GET
    @Timed
    @Path(value="/namespace/{namespace}")
    @ApiOperation(value="Get all metrics of a namespace")
    @ApiResponses(value={@ApiResponse(code=404, message="No such metric namespace")})
    @Produces(value={"application/json"})
    public MetricsSummaryResponse byNamespace(@ApiParam(name="namespace", required=true) @PathParam(value="namespace") String namespace) {
        ArrayList metrics = Lists.newArrayList();
        for (Map.Entry e : this.metricRegistry.getMetrics().entrySet()) {
            String metricName = (String)e.getKey();
            if (!metricName.startsWith(namespace) || !this.isPermitted("metrics:read", metricName)) continue;
            try {
                Metric metric = (Metric)e.getValue();
                metrics.add(MetricUtils.map(metricName, metric));
            }
            catch (Exception ex) {
                LOG.warn("Could not read metric in namespace list.", (Throwable)ex);
            }
        }
        if (metrics.isEmpty()) {
            String msg = "No metrics with namespace [" + namespace + "] found.";
            LOG.debug(msg);
            throw new NotFoundException(msg);
        }
        return MetricsSummaryResponse.create(metrics);
    }
}

