/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bson.types.ObjectId;
import org.graylog2.database.CollectionName;
import org.graylog2.database.PersistedImpl;
import org.graylog2.database.validators.FilledStringValidator;
import org.graylog2.database.validators.IntegerValidator;
import org.graylog2.database.validators.ObjectIdValidator;
import org.graylog2.database.validators.OptionalStringValidator;
import org.graylog2.plugin.database.validators.Validator;
import org.graylog2.plugin.streams.StreamRule;
import org.graylog2.plugin.streams.StreamRuleType;

@CollectionName(value="streamrules")
public class StreamRuleImpl
extends PersistedImpl
implements StreamRule {
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_VALUE = "value";
    public static final String FIELD_FIELD = "field";
    public static final String FIELD_INVERTED = "inverted";
    public static final String FIELD_STREAM_ID = "stream_id";
    public static final String FIELD_CONTENT_PACK = "content_pack";
    public static final String FIELD_DESCRIPTION = "description";

    public StreamRuleImpl(Map<String, Object> fields) {
        super(fields);
    }

    protected StreamRuleImpl(ObjectId id, Map<String, Object> fields) {
        super(id, fields);
    }

    @Override
    public StreamRuleType getType() {
        return StreamRuleType.fromInteger((Integer)this.fields.get(FIELD_TYPE));
    }

    @Override
    public void setType(StreamRuleType type) {
        this.fields.put(FIELD_TYPE, type.toInteger());
    }

    @Override
    public String getValue() {
        return (String)this.fields.get(FIELD_VALUE);
    }

    @Override
    public void setValue(String value) {
        this.fields.put(FIELD_VALUE, value);
    }

    @Override
    public String getField() {
        return (String)this.fields.get(FIELD_FIELD);
    }

    @Override
    public void setField(String field) {
        this.fields.put(FIELD_FIELD, field);
    }

    @Override
    public Boolean getInverted() {
        return (Boolean)MoreObjects.firstNonNull(this.fields.get(FIELD_INVERTED), (Object)false);
    }

    @Override
    public void setInverted(Boolean inverted) {
        this.fields.put(FIELD_INVERTED, inverted);
    }

    @Override
    public String getStreamId() {
        return ((ObjectId)this.fields.get(FIELD_STREAM_ID)).toHexString();
    }

    @Override
    public String getContentPack() {
        return (String)this.fields.get(FIELD_CONTENT_PACK);
    }

    @Override
    public void setContentPack(String contentPack) {
        this.fields.put(FIELD_CONTENT_PACK, contentPack);
    }

    @Override
    public String getDescription() {
        return (String)this.fields.get(FIELD_DESCRIPTION);
    }

    @Override
    public void setDescription(String description) {
        this.fields.put(FIELD_DESCRIPTION, description);
    }

    @Override
    public Map<String, Validator> getValidations() {
        ImmutableMap.Builder validators = ImmutableMap.builder();
        validators.put((Object)FIELD_TYPE, (Object)new IntegerValidator());
        validators.put((Object)FIELD_FIELD, (Object)new FilledStringValidator());
        validators.put((Object)FIELD_STREAM_ID, (Object)new ObjectIdValidator());
        validators.put((Object)FIELD_CONTENT_PACK, (Object)new OptionalStringValidator());
        if (!this.getType().equals((Object)StreamRuleType.PRESENCE)) {
            validators.put((Object)FIELD_VALUE, (Object)new FilledStringValidator());
        }
        return validators.build();
    }

    @Override
    public Map<String, Validator> getEmbeddedValidations(String key) {
        return Collections.emptyMap();
    }

    @Override
    @JsonValue
    public Map<String, Object> asMap() {
        HashMap result = Maps.newHashMap((Map)this.fields);
        result.remove("_id");
        result.put("id", this.getId());
        result.put(FIELD_STREAM_ID, this.getStreamId());
        return result;
    }

    @Override
    public String toString() {
        return "StreamRuleImpl: <" + this.fields.toString() + ">";
    }
}

