/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.plugin.Plugin;
import org.graylog2.shared.plugins.PluginLoader;
import org.graylog2.web.ModuleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginAssets {
    private static final Logger LOG = LoggerFactory.getLogger(PluginAssets.class);
    public static String pathPrefix = "web-interface/assets";
    private static String pluginPathPrefix = "plugin/";
    private static String manifestFilename = "module.json";
    private final ObjectMapper objectMapper;
    private final List<String> jsFiles;
    private final List<String> cssFiles;
    private final String polyfillJsFile;

    @Inject
    public PluginAssets(Set<Plugin> plugins, ObjectMapper objectMapper) {
        ModuleManifest manifest;
        this.objectMapper = objectMapper;
        this.jsFiles = new ArrayList<String>();
        this.cssFiles = new ArrayList<String>();
        plugins.stream().forEach(plugin -> {
            ModuleManifest pluginManifest = this.manifestForPlugin((Plugin)plugin);
            String pathPrefix = pluginPathPrefix + plugin.metadata().getUniqueId() + "/";
            if (pluginManifest != null) {
                this.jsFiles.addAll(this.prefixFileNames(pluginManifest.files().jsFiles(), pathPrefix));
                this.cssFiles.addAll(this.prefixFileNames(pluginManifest.files().cssFiles(), pathPrefix));
            }
        });
        InputStream packageManifest = this.getClass().getResourceAsStream("/" + pathPrefix + "/" + manifestFilename);
        if (packageManifest != null) {
            try {
                manifest = (ModuleManifest)objectMapper.readValue(packageManifest, ModuleManifest.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read web interface manifest: ", e);
            }
        } else {
            throw new IllegalStateException("Unable to find web interface assets. Maybe the web interface was not built into server?");
        }
        this.jsFiles.addAll(manifest.files().jsFiles());
        this.cssFiles.addAll(manifest.files().cssFiles());
        this.polyfillJsFile = manifest.files().chunks().get("polyfill").entry();
    }

    public List<String> jsFiles() {
        return this.jsFiles;
    }

    public List<String> sortedJsFiles() {
        List<String> sortedJsFiles = this.jsFiles().stream().sorted((file1, file2) -> {
            if (file1.equals(this.polyfillJsFile)) {
                return -1;
            }
            if (file2.equals(this.polyfillJsFile)) {
                return 1;
            }
            return file2.compareTo((String)file1);
        }).collect(Collectors.toList());
        return sortedJsFiles;
    }

    public List<String> cssFiles() {
        return this.cssFiles;
    }

    private List<String> prefixFileNames(List<String> filenames, String pathPrefix) {
        return filenames.stream().map(file -> file.startsWith(pathPrefix) ? file : pathPrefix + file).collect(Collectors.toList());
    }

    private ModuleManifest manifestForPlugin(Plugin plugin) {
        if (!(plugin instanceof PluginLoader.PluginAdapter)) {
            LOG.warn("Unable to read web manifest from plugin " + plugin + ": Plugin is not an instance of PluginAdapter.");
            return null;
        }
        String pluginClassName = ((PluginLoader.PluginAdapter)plugin).getPluginClassName();
        InputStream manifestStream = plugin.metadata().getClass().getResourceAsStream("/plugin." + pluginClassName + "." + manifestFilename);
        if (manifestStream != null) {
            try {
                ModuleManifest manifest = (ModuleManifest)this.objectMapper.readValue(manifestStream, ModuleManifest.class);
                return manifest;
            }
            catch (IOException e) {
                LOG.warn("Unable to read web manifest from plugin " + plugin + ": ", (Throwable)e);
            }
        }
        LOG.debug("No valid web manifest found for plugin " + plugin);
        return null;
    }
}

