/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.web.resources;

import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.activation.MimetypesFileTypeMap;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.server.ContainerRequest;
import org.graylog2.plugin.Plugin;
import org.graylog2.web.IndexHtmlGenerator;
import org.graylog2.web.PluginAssets;

@Singleton
@Path(value="")
public class WebInterfaceAssetsResource {
    private final MimetypesFileTypeMap mimeTypes;
    private final IndexHtmlGenerator indexHtmlGenerator;
    private final Set<Plugin> plugins;
    private final LoadingCache<URI, FileSystem> fileSystemCache;

    @Inject
    public WebInterfaceAssetsResource(IndexHtmlGenerator indexHtmlGenerator, Set<Plugin> plugins, MimetypesFileTypeMap mimeTypes) {
        this.indexHtmlGenerator = indexHtmlGenerator;
        this.plugins = plugins;
        this.mimeTypes = Objects.requireNonNull(mimeTypes);
        this.fileSystemCache = CacheBuilder.newBuilder().maximumSize(1024L).build((CacheLoader)new CacheLoader<URI, FileSystem>(){

            public FileSystem load(@Nonnull URI key) throws Exception {
                try {
                    return FileSystems.getFileSystem(key);
                }
                catch (FileSystemNotFoundException e) {
                    try {
                        return FileSystems.newFileSystem(key, Collections.emptyMap());
                    }
                    catch (FileSystemAlreadyExistsException f) {
                        return FileSystems.getFileSystem(key);
                    }
                }
            }
        });
    }

    @Path(value="plugin/{plugin}/{filename}")
    @GET
    public Response get(@Context Request request, @PathParam(value="plugin") String pluginName, @PathParam(value="filename") String filename) {
        Optional<Plugin> plugin = this.getPluginForName(pluginName);
        if (!plugin.isPresent()) {
            throw new NotFoundException("Couldn't find plugin " + pluginName);
        }
        try {
            URL resourceUrl = this.getResourceUri(true, filename, plugin.get().metadata().getClass());
            return this.getResponse(request, filename, resourceUrl, true);
        }
        catch (IOException | URISyntaxException e) {
            throw new NotFoundException("Couldn't find " + filename + " in plugin " + pluginName, (Throwable)e);
        }
    }

    private Optional<Plugin> getPluginForName(String pluginName) {
        return this.plugins.stream().filter(plugin -> plugin.metadata().getUniqueId().equals(pluginName)).findFirst();
    }

    @Path(value="{filename: .*}")
    @GET
    public Response get(@Context Request request, @PathParam(value="filename") String filename) {
        if (filename == null || filename.isEmpty() || filename.equals("/") || filename.equals("index.html")) {
            return this.getDefaultResponse();
        }
        try {
            URL resourceUrl = this.getResourceUri(false, filename, this.getClass());
            return this.getResponse(request, filename, resourceUrl, false);
        }
        catch (IOException | URISyntaxException e) {
            return this.getDefaultResponse();
        }
    }

    @GET
    public Response getIndex(@Context ContainerRequest request) {
        URI originalLocation = request.getRequestUri();
        if (originalLocation.getPath().endsWith("/")) {
            return this.get((Request)request, originalLocation.getPath());
        }
        URI redirect = UriBuilder.fromPath((String)(originalLocation.getPath() + "/")).build(new Object[0]);
        return Response.temporaryRedirect((URI)redirect).build();
    }

    private Response getResponse(Request request, String filename, URL resourceUrl, boolean fromPlugin) throws IOException, URISyntaxException {
        HashCode hashCode;
        InputStream stream;
        Date lastModified;
        switch (resourceUrl.getProtocol()) {
            case "file": {
                String fileName = resourceUrl.getFile();
                File file = new File(fileName);
                lastModified = new Date(file.lastModified());
                stream = new FileInputStream(file);
                hashCode = com.google.common.io.Files.hash((File)file, (HashFunction)Hashing.sha256());
                break;
            }
            case "jar": {
                URI uri = resourceUrl.toURI();
                FileSystem fileSystem = (FileSystem)this.fileSystemCache.getUnchecked((Object)uri);
                java.nio.file.Path path = fileSystem.getPath(this.pluginPrefixFilename(fromPlugin, filename), new String[0]);
                FileTime lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
                lastModified = new Date(lastModifiedTime.toMillis());
                stream = resourceUrl.openStream();
                hashCode = Resources.asByteSource((URL)resourceUrl).hash(Hashing.sha256());
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a jar or file");
            }
        }
        EntityTag entityTag = new EntityTag(hashCode.toString());
        Response.ResponseBuilder response = request.evaluatePreconditions(lastModified, entityTag);
        if (response != null) {
            return response.build();
        }
        String contentType = (String)MoreObjects.firstNonNull((Object)this.mimeTypes.getContentType(filename), (Object)"application/octet-stream");
        CacheControl cacheControl = new CacheControl();
        cacheControl.setMaxAge((int)TimeUnit.DAYS.toSeconds(365L));
        cacheControl.setNoCache(false);
        cacheControl.setPrivate(false);
        return Response.ok((Object)stream).header("Content-Type", (Object)contentType).tag(entityTag).cacheControl(cacheControl).lastModified(lastModified).build();
    }

    private URL getResourceUri(boolean fromPlugin, String filename, Class<?> aClass) throws URISyntaxException, FileNotFoundException {
        URL resourceUrl = aClass.getResource(this.pluginPrefixFilename(fromPlugin, filename));
        if (resourceUrl == null) {
            throw new FileNotFoundException("Resource file " + filename + " not found.");
        }
        return resourceUrl;
    }

    @Nonnull
    private String pluginPrefixFilename(boolean fromPlugin, String filename) {
        if (fromPlugin) {
            return "/" + filename;
        }
        return "/" + PluginAssets.pathPrefix + "/" + filename;
    }

    private Response getDefaultResponse() {
        return Response.ok((Object)this.indexHtmlGenerator.get()).header("Content-Type", (Object)"text/html").header("X-UA-Compatible", (Object)"IE=edge").build();
    }
}

